# Copyright 2023-2025 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Pythonic FP - Functional Programming Tools
==========================================

Functions as first class objects, Lazy (non-strict) function evaluation,
and classical Functional Programming data structures.

+--------------------------+------------------------------+
| Description              | Module                       |
+==========================+==============================+
| Function manipulation    | pythonic_fp.fptools.function |
+--------------------------+------------------------------+
| Lazy function evaluation | pythonic_fp.fptools.lazy     |
+--------------------------+------------------------------+
| Maybe monad              | pythonic_fp.fptools.maybe    |
+--------------------------+------------------------------+
| Either monad             | pythonic_fp.fptools.either   |
+--------------------------+------------------------------+
| State monad              | pythonic_fp.fptools.state    |
+--------------------------+------------------------------+

"""

__author__ = 'Geoffrey R. Scheller'
__copyright__ = 'Copyright (c) 2023-2025 Geoffrey R. Scheller'
__license__ = 'Apache License 2.0'
