from .maybe import MayBe
from collections.abc import Callable
from typing import Any

__all__ = ['Lazy', 'lazy', 'real_lazy']

class Lazy[D, R]:
    def __init__(self, f: Callable[[D], R], d: D, pure: bool = True) -> None: ...
    def __bool__(self) -> bool: ...
    def eval(self) -> None: ...
    def got_result(self) -> MayBe[bool]: ...
    def got_exception(self) -> MayBe[bool]: ...
    def get(self, alt: R | None = None) -> R: ...
    def get_result(self) -> MayBe[R]: ...
    def get_exception(self) -> MayBe[Exception]: ...

def lazy[**P, R](f: Callable[P, R], *args: P.args, **kwargs: P.kwargs) -> Lazy[tuple[Any, ...], R]: ...
def real_lazy[**P, R](f: Callable[P, R], *args: P.args, **kwargs: P.kwargs) -> Lazy[tuple[Any, ...], R]: ...
