from .maybe import MayBe
from _typeshed import Incomplete
from collections.abc import Callable, Iterator, Sequence
from pythonic_fp.booleans.subtypable import SBool
from typing import overload

__all__ = ['Either', 'LEFT', 'RIGHT']

class EitherBool(SBool): ...

LEFT: Incomplete
RIGHT: Incomplete

class Either[L, R]:
    __match_args__: Incomplete
    @overload
    def __init__(self, value: L) -> None: ...
    @overload
    def __init__(self, value: L, side: EitherBool) -> None: ...
    @overload
    def __init__(self, value: R, side: EitherBool) -> None: ...
    def __hash__(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __iter__(self) -> Iterator[L]: ...
    def __len__(self) -> int: ...
    def __eq__(self, other: object) -> bool: ...
    def get(self) -> L: ...
    def get_left(self) -> MayBe[L]: ...
    def get_right(self) -> MayBe[R]: ...
    def map_right[V](self, f: Callable[[R], V]) -> Either[L, V]: ...
    def map[U](self, f: Callable[[L], U]) -> Either[U, R]: ...
    def bind[U](self, f: Callable[[L], Either[U, R]]) -> Either[U, R]: ...
    def map_except[U](self, f: Callable[[L], U], fallback_right: R) -> Either[U, R]: ...
    def bind_except[U](self, f: Callable[[L], Either[U, R]], fallback_right: R) -> Either[U, R]: ...
    @staticmethod
    def sequence[U, V](sequence_xor_uv: Sequence[Either[U, V]]) -> Either[Sequence[U], V]: ...
