from collections.abc import Callable
from typing import Any, ParamSpec

__all__ = ['swap', 'compose', 'negate', 'sequenced', 'partial']

P = ParamSpec('P')

def swap[U, V, R](f: Callable[[U, V], R]) -> Callable[[V, U], R]: ...
def compose[D, T, R](f: Callable[[D], T], g: Callable[[T], R]) -> Callable[[D], R]: ...
def negate[**P](f: Callable[P, bool]) -> Callable[P, bool]: ...
def sequenced[R](f: Callable[..., R]) -> Callable[[tuple[Any]], R]: ...
def partial[**P, R](f: Callable[P, R], *args: Any) -> Callable[..., R]: ...
