# Copyright 2023-2025 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Simple Gadgets
==============

Library of simple, but useful, functions and classes with minimal dependencies.

+------------------------------+------------------+------------------------------------------------+
| Description                  | Gadget           | Module                                         |
+==============================+==================+================================================+
| Single item box              | class ``Box``    | ``pythonic_fp.gadgets.box``                    |
+------------------------------+------------------+------------------------------------------------+
| Return Iterator of arguments | function ``ita`` | ``pythonic_fp.gadgets.iterate_arguments``      |
+------------------------------+------------------+------------------------------------------------+
| Find least common base class | function ``lca`` | ``pythonic_fp.gadgets.latest_common_ancestor`` |
+------------------------------+------------------+------------------------------------------------+

"""

__author__ = 'Geoffrey R. Scheller'
__copyright__ = 'Copyright (c) 2023-2025 Geoffrey R. Scheller'
__license__ = 'Apache License 2.0'
