from collections.abc import Callable, Iterable, Iterator
from pythonic_fp.fptools.maybe import MayBe
from pythonic_fp.gadgets.sentinels.novalue import NoValue
from typing import Never

__all__ = ['accumulate', 'reduce_left', 'fold_left', 'maybe_fold_left', 'sc_reduce_left', 'sc_reduce_right']

def accumulate[D, L](iterable: Iterable[D], f: Callable[[L, D], L], initial: L | NoValue = ...) -> Iterator[L]: ...
def reduce_left[D](iterable: Iterable[D], f: Callable[[D, D], D]) -> D | Never: ...
def fold_left[D, L](iterable: Iterable[D], f: Callable[[L, D], L], initial: L) -> L | Never: ...
def maybe_fold_left[D, L](iterable: Iterable[D], f: Callable[[L, D], L], initial: L | NoValue = ...) -> MayBe[L] | Never: ...
def sc_reduce_left[D](iterable: Iterable[D], f: Callable[[D, D], D], start: Callable[[D], bool] = ..., stop: Callable[[D], bool] = ..., include_start: bool = True, include_stop: bool = True) -> tuple[MayBe[D], Iterator[D]]: ...
def sc_reduce_right[D](iterable: Iterable[D], f: Callable[[D, D], D], start: Callable[[D], bool] = ..., stop: Callable[[D], bool] = ..., include_start: bool = True, include_stop: bool = True) -> tuple[MayBe[D], Iterator[D]]: ...
