import abc
import numpy as np
import numpy.typing as npt
from abc import ABC
from enum import Enum

__all__ = ['DTypes', 'HWrapNDArray', 'HWrapNDArrayNumber', 'HWrapNDArrayString', 'HWrapNDArrayBytes', 'HWrapNDArrayVoid', 'HWrapNDArrayObject', 'HWrapNDArrayDateTime', 'HWrapNDArrayTimeDelta', 'HWrapNDArrayBool']

class DTypes(Enum):
    number = ...
    str_ = ...
    bytes = ...
    void = ...
    object_ = ...
    datetime64 = ...
    timedelta64 = ...
    bool_ = ...

class HWrapNDArray(ABC, metaclass=abc.ABCMeta):
    def __init__(self, ndarray: npt.NDArray[np.generic]) -> None: ...
    def __call__(self) -> npt.NDArray[np.number]: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: object) -> bool: ...
    def copy(self) -> npt.NDArray[np.number]: ...

class HWrapNDArrayNumber(HWrapNDArray):
    def __init__(self, ndarray: npt.NDArray[np.number]) -> None: ...

class HWrapNDArrayString(HWrapNDArray):
    def __init__(self, ndarray: npt.NDArray[np.str_]) -> None: ...

class HWrapNDArrayBytes(HWrapNDArray):
    def __init__(self, ndarray: npt.NDArray[np.bytes_]) -> None: ...

class HWrapNDArrayVoid(HWrapNDArray):
    def __init__(self, ndarray: npt.NDArray[np.void]) -> None: ...

class HWrapNDArrayObject(HWrapNDArray):
    def __init__(self, ndarray: npt.NDArray[np.object_]) -> None: ...

class HWrapNDArrayDateTime(HWrapNDArray):
    def __init__(self, ndarray: npt.NDArray[np.datetime64]) -> None: ...

class HWrapNDArrayTimeDelta(HWrapNDArray):
    def __init__(self, ndarray: npt.NDArray[np.timedelta64]) -> None: ...

class HWrapNDArrayBool(HWrapNDArray):
    def __init__(self, ndarray: npt.NDArray[np.bool_]) -> None: ...
