# Copyright 2023-2025 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from collections.abc import Callable, Hashable, Iterator
from typing import TypeVar

__all__ = ['SplitEnd']

D = TypeVar('D', bound=Hashable)

class SplitEnd[D]:
    __slots__ = '_count', '_tip', '_root'

    def __init__(self, root_data: D, *data: D) -> None: ...
    def __iter__(self) -> Iterator[D]: ...
    def __reversed__(self) -> Iterator[D]: ...
    def __bool__(self) -> bool: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...
    def __eq__(self, other: object, /) -> bool: ...
    def extend(self, *ds: D) -> None: ...
    def snip(self) -> D: ...
    def peak(self) -> D: ...
    def copy(self) -> SplitEnd[D]: ...
    def fold[T](self, f: Callable[[T, D], T], init: T | None = None) -> T: ...
    def rev_fold[T](self, f: Callable[[T, D], T], init: T | None = None) -> T: ...
