from collections.abc import Callable, Iterator
from pythonic_fp.gadgets.sentinels.flavored import Sentinel
from typing import Self, overload

__all__ = ['SENode']

type _Sentinel = Sentinel[str]
class SENode[D]:
    def __init__(self, data: D, prev: Self | _Sentinel = ...) -> None: ...
    def __bool__(self) -> bool: ...
    def __iter__(self) -> Iterator[D]: ...
    def __eq__(self, other: object) -> bool: ...
    def both(self) -> tuple[D, Self]: ...
    def data(self) -> D: ...
    def prev(self) -> Self: ...
    def push(self, data: D) -> Self: ...
    @overload
    def fold(self, f: Callable[[D, D], D]) -> D: ...
    @overload
    def fold[T](self, f: Callable[[T, D], T], init: T) -> T: ...
