# Copyright 2023-2025 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Pythonic FP projects
====================

Developer Tools supporting a functional style of programming yet endeavoring
to remain Pythonic. Project names begin ``pythonic-fp-`` on PyPI and
``grscheller/pythonic-fp-`` on GitHub. As Python modules, all are under
the ``pythonic_fp`` package name.

A complete list of links to the PyPI and GitHub repos making up the project
can be found
`here <https://github.com/grscheller/pythonic-fp/blob/main/README.md>`_
on GitHub.

Goals
-----

- to assist in a functional style of programming
- to fulling support typing and tooling like `mypy <https://mypy-lang.org/>`_
- support stateful as well as functional paradigms
- good documentation
- be extensible

Non-Goals
---------

- try and make Python a pure functional language like Haskell

Top level PyPI releases
-----------------------

+---------------------------+---------------------------+---------+------------+
| PyPI Project              | Python Module             | version | date       |
+===========================+===========================+=========+============+
| pythonic-fp-booleans      | pythonic_fp.booleans      | 1.1.2   | 2025-09-09 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-circulararray | pythonic_fp.circulararray | 6.0.0   | 2025-09-25 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-containers    | pythonic_fp.containers    | 3.0.1   | 2025-09-09 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-fptools       | pythonic_fp.fptools       | 5.1.1   | 2025-09-09 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-gadgets       | pythonic_fp.gadgets       | 3.0.1   | 2025-09-09 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-iterables     | pythonic_fp.iterables     | 5.1.1   | 2025-09-09 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-queues        | pythonic_fp.queues        | 5.1.0   | 2025-09-26 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-sentinels *   | pythonic_fp.sentinels     | 2.1.3   | 2025-08-02 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-singletons *  | pythonic_fp.singletons    | 1.0.0   | 2025-09-25 |
+---------------------------+---------------------------+---------+------------+
| pythonic-fp-splitends     | pythonic_fp.splitends     | 1.0.2   | 2025-09-25 |
+---------------------------+---------------------------+---------+------------+

\* Deprecated

"""
