pythonids
=========

**REMARK**: This is a nightly pre-build with some minor issues, the final release is following within a few days.

The ‘pythonids‘ package provides the enumeration of Python syntaxes and the
categorization of Python implementations.
This enables the development of fast and easy portable generic code for arbitrary platforms in IT and IoT landscapes 
consisting of heterogeneous physical and virtual runtime environments.

The current supported syntaxes are *Python2.7+* and *Python3* for the Python implementations:

* CPython
* IPython (based on CPython)
* IronPython
* Jython
* PyPy

Soon:

* MicroPython
* CircuitPython

The current supported platforms are:

* Linux, BSD, Unix, OS-X, Cygwin, and Windows

* x86, amd64, arm32/armhf, arm64/aarch64

* Servers, Workstations, Embedded Systems

* Datacenters, public and private Clouds, IoT 

**Online documentation**:

* https://pythonids.sourceforge.io/


**Runtime-Repository**:

* PyPI: https://pypi.org/project/pythonids/

  Install: *pip install pythonids*, see also section 'Install' of the online documentation.


**Downloads**:

* sourceforge.net: https://sourceforge.net/projects/pythonids/files/

* bitbucket.org: https://bitbucket.org/acue/pythonids

* github.com: https://github.com/ArnoCan/pythonids/

* pypi.org: https://pypi.org/project/pythonids/


Project Data
------------

* PROJECT: 'pythonids'

* MISSION: Canonical numeric platform IDs for the core Python environment.

* VERSION: 00.01

* RELEASE: 00.01.039

* STATUS: beta

* AUTHOR: Arno-Can Uestuensoez

* COPYRIGHT: Copyright (C) 2016-2019 Arno-Can Uestuensoez @Ingenieurbuero Arno-Can Uestuensoez

* LICENSE: Artistic-License-2.0 + Forced-Fairplay-Constraints

Runtime Environment
-------------------
For a comprehensive list refer to the documentation.

**Python Syntax Support**

*  Python2.7, and Python3

**Python Implementation Support**

*  CPython, IPython, IronPython, Jython, and PyPy

**OS on Server, Workstation, Laptops, Virtual Machines, and Containers**

* Linux: AlpineLinux, ArchLinux, CentOS, Debian, Fedora, Gentoo, OpenSUSE, Raspbian, RHEL, Slackware, SLES, Ubuntu, ...  

* BSD: DragonFlyBSD, FreeBSD, NetBSD, OpenBSD, GhostBSD, TrueOS, NomadBSD

* OS-X: Snow Leopard

* Windows: Win10, Win8.1, Win7, WinXP, Win2019, Win2016, Win2012, Win2008, Win2000

* WSL-1.0: Alpine, Debian, KaliLinux, openSUSE, SLES, Ubuntu

* Cygwin

* UNIX: Solaris10, Solaris11

* Minix: Minix3

* ReactOS

**Network and Security**

* Network Devices: OpenWRT

* Security: KaliLinux, pfSense, BlackArch, ParrotOS, Pentoo

**OS on Embedded Devices**

* RaspberryPI: ArchLinux, CentOS, OpenBSD, OpenWRT, Raspbian

* ASUS-TinkerBoard: Armbian

* By special modules e.g. for Adafruit Trinket M0: CircuitPython, MicroPython

Current Release
---------------

Major Changes:

* Initial version.

ToDo:

* AIX

* MicroPython, CircuitPython

* Stackless Python

* test OpenBSD on rpi3

* test Windows10IoT-Core

