"""
Common utilities and shared components for the Pythonium MCP server.

This package contains base classes, utilities, and shared components used
across all other packages in the Pythonium project. It provides the foundation
for the plugin framework and common services.
"""

__version__ = "0.1.0"

# Core imports
from pythonium.common.base import (
    BaseComponent,
    ComponentStatus,
    ConfigurableComponent,
    EventHandler,
    Provider,
    Registry,
    Result,
)
from pythonium.common.cache import (
    AsyncCache,
    BaseCache,
    CacheEntry,
    CacheError,
    CacheManager,
    CacheStats,
    EvictionPolicy,
    MemoryCache,
    cached,
    get_cache_manager,
    get_default_cache,
)
from pythonium.common.config import (
    CacheSettings,
    DatabaseSettings,
    LoggingSettings,
    PluginSettings,
    PythoniumSettings,
    SecuritySettings,
    ServerSettings,
    ToolSettings,
    get_settings,
    load_settings_from_file,
)
from pythonium.common.events import (
    EventBus,
    EventFilter,
    EventManager,
    EventPriority,
    EventSubscription,
    get_event_manager,
    set_event_manager,
    subscribe_to_event,
    unsubscribe_from_event,
)
from pythonium.common.exceptions import (
    ConfigurationError,
    InitializationError,
    ManagerError,
    MCPError,
    NetworkError,
    PluginError,
    PythoniumError,
    SecurityError,
    ToolError,
    ValidationError,
)
from pythonium.common.filesystem import (
    FileEvent,
    FileInfo,
    FileManager,
    FileOperation,
    FileSystemError,
    FileWatcher,
    PollingFileWatcher,
    calculate_file_hash,
    copy_file,
    delete_file,
    ensure_directory,
    file_lock,
    find_files,
    get_available_space,
    get_file_manager,
    get_file_size,
    is_text_file,
    list_directory,
    move_file,
    safe_path_join,
    temporary_directory,
    temporary_file,
)
from pythonium.common.logging import (
    LogFormat,
    LogLevel,
    audit_log,
    get_logger,
    performance_log,
    setup_logging,
)
from pythonium.common.plugin_factory import (
    ExtensiblePlugin,
    ExtensionManager,
    ExtensionPoint,
    HookPriority,
    MiddlewarePlugin,
    MiddlewareStack,
    PluginFactory,
    PluginType,
    extension_plugin,
    manager_plugin,
    middleware_plugin,
    plugin_hook,
    tool_plugin,
    transport_plugin,
)
from pythonium.common.plugins import (
    BasePlugin,
    DependencyResolver,
)
from pythonium.common.plugins import PluginConfig as PluginPluginConfig
from pythonium.common.plugins import (
    PluginDependency,
    PluginDiscovery,
    PluginLoader,
    PluginPriority,
    PluginRegistry,
)
from pythonium.common.resources import (
    Resource,
    ResourceError,
    ResourceInfo,
    ResourceManager,
    ResourcePool,
    async_managed_resource,
    get_resource_manager,
    managed_resource,
    pooled_resource,
)
from pythonium.common.serialization import (
    BaseSerializer,
    JSONSerializer,
    PickleSerializer,
    SerializationFormat,
    SerializationOptions,
    SerializerFactory,
    YAMLSerializer,
    deserialize,
    deserialize_from_file,
    deserialize_from_string,
    serialize,
    serialize_to_file,
    serialize_to_string,
)
from pythonium.common.types import (  # Protocols
    JSON,
    ComponentType,
    ConfigDict,
    Configurable,
    Discoverable,
    EventData,
    Executable,
    HealthCheckable,
    HealthStatus,
    Initializable,
    Manager,
    MCPServer,
    MCPTransport,
    MetadataDict,
    ParametersDict,
    Pluggable,
    PluginInfo,
    Priority,
    ResultData,
    Tool,
    ToolExecutionContext,
    ToolInfo,
    TransportType,
)

__all__ = [
    # Base classes
    "BaseComponent",
    "ConfigurableComponent",
    "ComponentStatus",
    "Result",
    "Registry",
    "EventHandler",
    "Provider",
    # Exceptions
    "PythoniumError",
    "ConfigurationError",
    "InitializationError",
    "PluginError",
    "ToolError",
    "ManagerError",
    "MCPError",
    "SecurityError",
    "ValidationError",
    # Logging
    "get_logger",
    "setup_logging",
    "LogLevel",
    "LogFormat",
    "audit_log",
    "performance_log",
    # Configuration
    "PythoniumConfig",
    "ServerConfig",
    "PluginConfig",
    "ToolConfig",
    "LoggingConfig",
    "SecurityConfig",
    "get_default_config",
    "PythoniumSettings",
    "get_settings",
    "load_settings_from_file",
    # Types and protocols
    "JSON",
    "ConfigDict",
    "MetadataDict",
    "ParametersDict",
    "ResultData",
    "ComponentType",
    "Priority",
    "TransportType",
    "HealthStatus",
    "EventData",
    "PluginInfo",
    "ToolInfo",
    "ToolExecutionContext",
    "Configurable",
    "Initializable",
    "HealthCheckable",
    "Discoverable",
    "Executable",
    "Pluggable",
    "Manager",
    "Tool",
    "MCPTransport",
    "MCPServer",
    # Plugin framework
    "BasePlugin",
    "PluginConfig",
    "PluginDependency",
    "PluginPriority",
    "PluginDiscovery",
    "PluginLoader",
    "DependencyResolver",
    "PluginRegistry",
    "PluginFactory",
    "ExtensionPoint",
    "ExtensionManager",
    "ExtensiblePlugin",
    "MiddlewarePlugin",
    "MiddlewareStack",
    "PluginType",
    "HookPriority",
    "plugin_hook",
    "tool_plugin",
    "manager_plugin",
    "transport_plugin",
    "middleware_plugin",
    "extension_plugin",
    # Events
    "EventBus",
    "EventManager",
    "EventSubscription",
    "EventFilter",
    "EventPriority",
    "get_event_manager",
    "set_event_manager",
    "subscribe_to_event",
    "unsubscribe_from_event",
    # Caching
    "BaseCache",
    "MemoryCache",
    "AsyncCache",
    "CacheManager",
    "CacheEntry",
    "CacheStats",
    "EvictionPolicy",
    "CacheError",
    "cached",
    "get_cache_manager",
    "get_default_cache",
    # Resources
    "Resource",
    "ResourcePool",
    "ResourceManager",
    "ResourceInfo",
    "ResourceError",
    "managed_resource",
    "async_managed_resource",
    "pooled_resource",
    "get_resource_manager",
    # Serialization
    "BaseSerializer",
    "JSONSerializer",
    "PickleSerializer",
    "YAMLSerializer",
    "SerializationFormat",
    "SerializationOptions",
    "SerializerFactory",
    "serialize",
    "deserialize",
    "serialize_to_string",
    "deserialize_from_string",
    "serialize_to_file",
    "deserialize_from_file",
    # Network
    "BaseHTTPClient",
    "AiohttpClient",
    "HttpxClient",
    "WebSocketClient",
    "HTTPRequest",
    "HTTPResponse",
    "HTTPMethod",
    "RetryConfig",
    "RateLimitConfig",
    "RateLimiter",
    "NetworkError",
    "ConnectionError",
    "TimeoutError",
    "RateLimitError",
    "http_client",
    "create_http_client",
    "get_default_client",
    "get",
    "post",
    "put",
    "delete",
    "check_port",
    "get_local_ip",
    "is_port_free",
    "find_free_port",
    # File system
    "FileInfo",
    "FileEvent",
    "FileOperation",
    "FileWatcher",
    "PollingFileWatcher",
    "FileManager",
    "FileSystemError",
    "safe_path_join",
    "ensure_directory",
    "copy_file",
    "move_file",
    "delete_file",
    "calculate_file_hash",
    "get_file_size",
    "get_available_space",
    "list_directory",
    "find_files",
    "is_text_file",
    "temporary_directory",
    "temporary_file",
    "file_lock",
    "get_file_manager",
]
