import os
from concurrent import futures
from os.path import dirname
import grpc
import multiprocessing
from importlib import import_module


class Servicer(object):
    def __init__(self, name, server):
        self.name = name
        self.handlers = {}
        self.server = server

    def endpoint(self, endpoint_name):
        def decorator(f):
            if endpoint_name not in self.handlers:
                def wrapper(self, *args, **kwargs):
                    return f(*args, **kwargs)
                self.handlers[endpoint_name] = wrapper
            return
        return decorator

    def response(self, res_type_name, res_dict):
        response_class = getattr(self.server.pb2_module, res_type_name)
        return response_class(**res_dict)


class PythonKit(object):
    server = None

    def __init__(self, name, protos):
        self.name = name
        self.servicers = {}
        self.protos = os.path.abspath(protos)
        self.rel_protos = os.path.relpath(os.path.dirname(protos))
        self.protos_dir = ''
        self.server_name = protos.split('/')[-1].split('.')[0]
        self.pb2_module = None
        self.pb2_grpc_module = None

    def create_servicer(self, servicer_name):
        if servicer_name not in self.servicers:
            servicer = Servicer(servicer_name, self)
            self.servicers[servicer_name] = servicer
        return self.servicers[servicer_name]

    def add_servicer(self, servicer):
        servicer.server = self
        self.servicers[servicer.name] = servicer

    def build_pb(self):

        """
        use tools to compile protobuff
        """
        from grpc_tools import protoc
        import sys
        protos_dirname = dirname(self.protos)
        # python3 do not support implicitly relative import,
        # and python script auto generated by grpc tools using implicitly relative import.
        # so it must add protos dir to python path.
        sys.path.append(protos_dirname)
        self.protos_dir = protos_dirname
        protoc.main([__name__, "-I{}".format(protos_dirname),
                     "--python_out={}".format(protos_dirname),
                     "--grpc_python_out={}".format(protos_dirname),
                     self.protos])

    def run(self, address, is_test=False):
        self.build_pb()
        self.server = grpc.server(futures.ThreadPoolExecutor(max_workers=(multiprocessing.cpu_count() * 2 + 1)))

        pb2_module_name = self.server_name + '_pb2'
        pb2_grpc_module_name = self.server_name + '_pb2_grpc'
        if self.rel_protos == '.':
            self.pb2_grpc_module = import_module('{}'.format(pb2_grpc_module_name))
            self.pb2_module = import_module('{}'.format(pb2_module_name))
        else:
            self.pb2_grpc_module = import_module('.{}'.format(pb2_grpc_module_name), self.rel_protos)
            self.pb2_module = import_module('.{}'.format(pb2_module_name), self.rel_protos)
        for servicer in self.servicers.values():
            # get grpc servicer class
            # create a class extend grpc servicer class
            servicer_class = getattr(self.pb2_grpc_module, '{}Servicer'.format(servicer.name))
            # add handler to this class
            servicer_class = type("test", (servicer_class,), servicer.handlers)

            add_method = getattr(self.pb2_grpc_module, 'add_{}Servicer_to_server'.format(servicer.name))
            add_method(servicer_class(), self.server)
        self.server.add_insecure_port(address)
        self.server.start()
        try:
            while True and not is_test:
                time.sleep(_25_HOURS_IN_SECONDS)
        except KeyboardInterrupt:
            self.server.stop(0)
