# HDRIs Renaming System

This system allows you to standardize the file names of HDRIs downloaded from various sources based on predefined naming codes. It also keeps track of the renaming process using a JSON file.

## Folder Structure

### With `pythonKitchen` as Root:

```
    pythonKitchen/
    │
    pythonKitchen/
    │
    └── textureRen/
        ├── hdri_file_attributes.csv
        ├── hdri.json
        ├── namingcodes.json
        ├── textures_renamed.json
        │
        └── scripts/
            ├── script1.py
            └── script2.py
```

### `VFX_LIB` variable stores Assests Library Root

```
    VFX_LIB/
    │
    ├── ingest/
    │   └── textures/
    │       └── hdri/
    │
    ├── hdri/
    
```


- `pythonKitchen/`: Root directory for the Python Kitchen repository.
- `pythonkitchen/`: Package containing the HDRIs renaming system.
- `textureRen/`: Subdirectory containing the HDRIs renaming system.
- `hdri_file_attributes.csv`: CSV file generated by Script 1 containing file attributes.
- `hdri.json`: JSON file containing the HDRIs data.
- `namingcodes.json`: JSON file containing the naming codes.
- `textures_renamed.json`: JSON file containing information about renamed HDRIs.
- `$VFX_LIB/ingest/textures/hdri/`: Folder where you download HDRIs from various sources.
- `scripts/`: Folder containing Python scripts for renaming HDRIs.
- `script1.py`: Script to list HDRIs and create CSV with file attributes.
- `script2.py`: Script to rename files and update renamed JSON.

## Usage

### Script 1: List HDRIs and Create CSV

- Run `script1.py` to list HDRIs in the ingest folder and generate a CSV file with file attributes.

    ```bash
    python pythonkitchen/textureRen/scripts/script1.py
    ```

    - This script will prompt you for naming codes for each file.

### Script 2: Rename Files and Update JSON

- After generating the CSV file, run `script2.py` to rename the files and update the JSON file.

    ```bash
    python pythonkitchen/textureRen/scripts/script2.py
    ```

    - This script will move the renamed files to the hdri folder and update the `renamed_hdri.json` file with the renaming information.

## Notes

- Ensure that the `namingcodes.json` file contains the correct naming codes.
- Make sure the folder paths in the scripts (`ingest_folder`, `hdri_folder`, `renamed_json_path`, etc.) match your directory structure.
- Customize the scripts according to your specific requirements if needed.


