#ifndef KNOT_DATA_H
#define KNOT_DATA_H

#include <string>
#include <map>
#include <ginac/ginac.h>

/*
1       1
3_1     -1+t-t^2
4_1     -1+3*t-t^2
5_1     1-t+t^2-t^3+t^4
5_2     2-3*t+2*t^2
6_1     -2+5*t-2*t^2
6_2     1-3*t+3*t^2-3*t^3+t^4 
6_3     1-3*t+5*t^2-3*t^3+t^4
7_1     1-t+t^2-t^3+t^4-t^5+t^6
7_2     3-5*t+3*t^2
7_3     2-3*t+3*t^2-3*t^3+2*t^4
7_4     4-7*t+4*t^2
7_5     2-4*t+5*t^2-4*t^3+2*t^4
7_6     1-5*t+7*t^2-5*t^3+t^4
7_7     1-5*t+9*t^2-5*t^3+t^4
8_1	3-7*t+3*t^2
8_2	1-3*t+3*t^2-3*t^3+3*t^4-3*t^5+t^6
8_3	4-9*t+4*t^2
8_4	2-5*t+5*t^2-5*t^3+2*t^4
8_5	1-3*t+4*t^2-5*t^3+4*t^4-3*t^5+t^6
8_6	2-6*t+7*t^2-6*t^3+2*t^4
8_7	1-3*t+5*t^2-5*t^3+5*t^4-3*t^5+t^6
8_8	2-6*t+9*t^2-6*t^3+2*t^4
8_9	1-3*t+5*t^2-7*t^3+5*t^4-3*t^5+t^6
8_10	1-3*t+6*t^2-7*t^3+6*t^4-3*t^5+t^6
8_11	2-7*t+9*t^2-7*t^3+2*t^4
8_12	1-7*t+13*t^2-7*t^3+t^4
8_13	2-7*t+11*t^2-7*t^3+2*t^4
8_14	2-8*t+11*t^2-8*t^3+2*t^4
8_15	3-8*t+11*t^2-8*t^3+3*t^4
8_16	1-4*t+8*t^2-9*t^3+8*t^4-4*t^5+t^6
8_17	1-4*t+8*t^2-11*t^3+8*t^4-4*t^5+t^6
8_18	1-5*t+10*t^2-13*t^3+10*t^4-5*t^5+t^6
8_19	1-t+t^3-t^5+t^6
8_20	1-2*t+3*t^2-2*t^3+t^4
8_21	1-4*t+5*t^2-4*t^3+t^4
*/

GiNaC::symbol t("t");
GiNaC::lst syms={t};
static std::map<GiNaC::ex,std::string,GiNaC::ex_is_less>  alexander_polynomial = 
{
    {GiNaC::ex("1",syms), "1"},
    {GiNaC::ex("-1+t-t^2",syms), "3_1"},
    {GiNaC::ex("-1+3*t-t^2",syms), "4_1"},
    {GiNaC::ex("1-t+t^2-t^3+t^4",syms), "5_1"},
    {GiNaC::ex("2-3*t+2*t^2",syms), "5_2"},
    {GiNaC::ex("-2+5*t-2*t^2",syms), "6_1"},
    {GiNaC::ex("1-3*t+3*t^2-3*t^3+t^4",syms), "6_2"},
    {GiNaC::ex("1-3*t+5*t^2-3*t^3+t^4",syms), "6_3"},
    {GiNaC::ex("1-t+t^2-t^3+t^4-t^5+t^6",syms), "7_1"},
    {GiNaC::ex("3-5*t+3*t^2",syms), "7_2"},
    {GiNaC::ex("2-3*t+3*t^2-3*t^3+2*t^4",syms), "7_3"},
    {GiNaC::ex("4-7*t+4*t^2",syms), "7_4"},
    {GiNaC::ex("2-4*t+5*t^2-4*t^3+2*t^4",syms), "7_5"},
    {GiNaC::ex("1-5*t+7*t^2-5*t^3+t^4",syms), "7_6"},
    {GiNaC::ex("1-5*t+9*t^2-5*t^3+t^4",syms), "7_7"},
    {GiNaC::ex("3-7*t+3*t^2",syms), "8_1"},
    {GiNaC::ex("1-3*t+3*t^2-3*t^3+3*t^4-3*t^5+t^6",syms), "8_2"},
    {GiNaC::ex("4-9*t+4*t^2",syms), "8_3"},
    {GiNaC::ex("2-5*t+5*t^2-5*t^3+2*t^4",syms), "8_4"},
    {GiNaC::ex("1-3*t+4*t^2-5*t^3+4*t^4-3*t^5+t^6",syms), "8_5"},
    {GiNaC::ex("2-6*t+7*t^2-6*t^3+2*t^4",syms), "8_6"},
    {GiNaC::ex("1-3*t+5*t^2-5*t^3+5*t^4-3*t^5+t^6",syms), "8_7"},
    {GiNaC::ex("2-6*t+9*t^2-6*t^3+2*t^4",syms), "8_8"},
    {GiNaC::ex("1-3*t+5*t^2-7*t^3+5*t^4-3*t^5+t^6",syms), "8_9"},
    {GiNaC::ex("1-3*t+6*t^2-7*t^3+6*t^4-3*t^5+t^6",syms), "8_10"},
    {GiNaC::ex("2-7*t+9*t^2-7*t^3+2*t^4",syms), "8_11"},
    {GiNaC::ex("1-7*t+13*t^2-7*t^3+t^4",syms), "8_12"},
    {GiNaC::ex("2-7*t+11*t^2-7*t^3+2*t^4",syms), "8_13"},
    {GiNaC::ex("2-8*t+11*t^2-8*t^3+2*t^4",syms), "8_14"},
    {GiNaC::ex("3-8*t+11*t^2-8*t^3+3*t^4",syms), "8_15"},
    {GiNaC::ex("1-4*t+8*t^2-9*t^3+8*t^4-4*t^5+t^6",syms), "8_16"},
    {GiNaC::ex("1-4*t+8*t^2-11*t^3+8*t^4-4*t^5+t^6",syms), "8_17"},
    {GiNaC::ex("1-5*t+10*t^2-13*t^3+10*t^4-5*t^5+t^6",syms), "8_18"},
    {GiNaC::ex("1-t+t^3-t^5+t^6",syms), "8_19"},
    {GiNaC::ex("1-2*t+3*t^2-2*t^3+t^4",syms), "8_20"},
    {GiNaC::ex("1-4*t+5*t^2-4*t^3+t^4",syms), "8_21"}
};



#endif