
# pythonlib

Gelişmiş otomatik agent ve analiz özellikli Python kütüphanesi.

## Özellikler
- DeepAnalyzerAgent: Kodunuzu satır, harf, rakam, sembol bazında analiz eder, hata ve uyumsuzlukları raporlar.
- AutoLibraryFixerAgent: Kütüphane importlarını, fonksiyon ve versiyon uyumsuzluklarını tespit eder, eksikleri otomatik düzeltir.
- Modüler mimari, API/fonksiyon entegrasyonu.
- Gelişmiş hata yönetimi ve logging.
- Otomatik test altyapısı ve CI/CD entegrasyonu.

## Kurulum
```bash
pip install -e .
```

## Kullanım
```python
from src.deep_analyzer_agent import DeepAnalyzerAgent
from src.auto_library_fixer_agent import AutoLibraryFixerAgent

analyzer = DeepAnalyzerAgent(root_dir="src")
analyzer.scan_and_analyze(auto_fix=True)

fixer = AutoLibraryFixerAgent(root_dir="src")
fixer.analyze_and_fix()
fixer.teach_deep_analyzer()
```

## Testler
```bash
python -m unittest discover -s tests
```

## CI/CD
- Otomatik testler ve kalite kontrolü `.github/workflows/python-ci.yml` ile sağlanır.

## Katkı
- Her modül ve fonksiyon için docstring ekleyin.
- Test ve örnek kodlarla katkıda bulunun.

## Lisans
MIT