from setuptools import setup, find_packages

setup(
    name="pythonlib-agent-suite",
    version="1.0.0",
    description="Otomatik analiz, düzeltme ve raporlama için agent tabanlı Python kütüphanesi.",
    author="emrecnyngmail.com",
    author_email="emrecnyngmail.com@gmail.com",
    packages=find_packages(where="src"),
    package_dir={"": "src"},
    install_requires=[
        "fpdf",
        "Flask",
        "requests",
        "pandas",
        "numpy",
        "scikit-learn",
        "torch",
        "mlflow",
        "dvc",
        "fastai",
        "streamlit",
        "gitpython",
        "dbt-core",
        "neptune",
        "comet-ml",
        "seldon-core",
        "onnx",
        "great_expectations",
        "databricks-cli",
        "wandb",
        "chardet"
    ],
    python_requires=">=3.10",
    include_package_data=True,
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
)