import unittest
from src.deep_analyzer_agent import DeepAnalyzerAgent
from src.auto_library_fixer_agent import AutoLibraryFixerAgent
import os

class TestDeepAnalyzerAgent(unittest.TestCase):
    def setUp(self):
        self.agent = DeepAnalyzerAgent(root_dir="src")

    def test_analyze_file_exists(self):
        test_file = "src/deep_analyzer_agent.py"
        self.assertTrue(os.path.exists(test_file))
        self.agent.analyze_file(test_file)
        self.assertGreaterEqual(len(self.agent.issues), 0)

    def test_analyze_nonexistent_file(self):
        test_file = "src/nonexistent.py"
        self.agent.analyze_file(test_file)
        self.assertTrue(any("File not found" in issue for issue in [i[2] for i in self.agent.issues]))

class TestAutoLibraryFixerAgent(unittest.TestCase):
    def setUp(self):
        self.agent = AutoLibraryFixerAgent(root_dir="src")

    def test_analyze_imports(self):
        test_file = "src/auto_library_fixer_agent.py"
        missing = self.agent.analyze_imports(test_file)
        self.assertIsInstance(missing, list)

if __name__ == "__main__":
    unittest.main()
