import unittest
from src.file_operations import write_to_file, read_from_file, count_lines
import os

class TestFileOperations(unittest.TestCase):
    def setUp(self):
        self.filename = 'testfile.txt'
        self.text = 'Line1\nLine2\nLine3'

    def tearDown(self):
        if os.path.exists(self.filename):
            os.remove(self.filename)

    def test_write_and_read(self):
        write_to_file(self.filename, self.text)
        result = read_from_file(self.filename)
        self.assertEqual(result, self.text)

    def test_count_lines(self):
        write_to_file(self.filename, self.text)
        self.assertEqual(count_lines(self.filename), 3)

if __name__ == "__main__":
    unittest.main()
