import unittest
from src.regular_expressions import find_digits, find_emails

class TestRegularExpressions(unittest.TestCase):
    def test_find_digits(self):
        self.assertEqual(find_digits("abc123def456"), ['123', '456'])

    def test_find_emails(self):
        text = "Contact: user@mail.com, admin@site.org"
        self.assertEqual(find_emails(text), ['user@mail.com', 'admin@site.org'])

if __name__ == "__main__":
    unittest.main()
