/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.Lists;
import com.google.inject.internal.cglib.proxy.$MethodInterceptor;
import com.google.inject.internal.cglib.proxy.$MethodProxy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

final class InterceptorStackCallback
implements $MethodInterceptor {
    private static final Set<String> AOP_INTERNAL_CLASSES = new HashSet<String>(Arrays.asList(InterceptorStackCallback.class.getName(), InterceptedMethodInvocation.class.getName(), $MethodProxy.class.getName()));
    final MethodInterceptor[] interceptors;
    final Method method;

    public InterceptorStackCallback(Method method, List<MethodInterceptor> interceptors) {
        this.method = method;
        this.interceptors = interceptors.toArray(new MethodInterceptor[interceptors.size()]);
    }

    @Override
    public Object intercept(Object proxy, Method method, Object[] arguments, $MethodProxy methodProxy) throws Throwable {
        return new InterceptedMethodInvocation(proxy, methodProxy, arguments, 0).proceed();
    }

    private void pruneStacktrace(Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            StackTraceElement[] stackTrace = t.getStackTrace();
            ArrayList<StackTraceElement> pruned = Lists.newArrayList();
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (AOP_INTERNAL_CLASSES.contains(className) || className.contains("$EnhancerByGuice$")) continue;
                pruned.add(element);
            }
            t.setStackTrace(pruned.toArray(new StackTraceElement[pruned.size()]));
        }
    }

    private class InterceptedMethodInvocation
    implements MethodInvocation {
        final Object proxy;
        final Object[] arguments;
        final $MethodProxy methodProxy;
        final int index;

        public InterceptedMethodInvocation(Object proxy, $MethodProxy methodProxy, Object[] arguments, int index) {
            this.proxy = proxy;
            this.methodProxy = methodProxy;
            this.arguments = arguments;
            this.index = index;
        }

        @Override
        public Object proceed() throws Throwable {
            try {
                return this.index == InterceptorStackCallback.this.interceptors.length ? this.methodProxy.invokeSuper(this.proxy, this.arguments) : InterceptorStackCallback.this.interceptors[this.index].invoke(new InterceptedMethodInvocation(this.proxy, this.methodProxy, this.arguments, this.index + 1));
            }
            catch (Throwable t) {
                InterceptorStackCallback.this.pruneStacktrace(t);
                throw t;
            }
        }

        @Override
        public Method getMethod() {
            return InterceptorStackCallback.this.method;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public Object getThis() {
            return this.proxy;
        }

        @Override
        public AccessibleObject getStaticPart() {
            return this.getMethod();
        }
    }
}

