/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.hessenberg;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.decomposition.UtilDecompositons_DDRM;
import org.ejml.dense.row.decomposition.qr.QrHelperFunctions_DDRM;
import org.ejml.interfaces.decomposition.DecompositionInterface;

public class HessenbergSimilarDecomposition_DDRM
implements DecompositionInterface<DMatrixRMaj> {
    private DMatrixRMaj QH;
    private int N;
    private double[] gammas;
    private double[] b;
    private double[] u;

    public HessenbergSimilarDecomposition_DDRM(int initialSize) {
        this.gammas = new double[initialSize];
        this.b = new double[initialSize];
        this.u = new double[initialSize];
    }

    public HessenbergSimilarDecomposition_DDRM() {
        this(5);
    }

    @Override
    public boolean decompose(DMatrixRMaj A2) {
        if (A2.numRows != A2.numCols) {
            throw new IllegalArgumentException("A must be square.");
        }
        if (A2.numRows <= 0) {
            return false;
        }
        this.QH = A2;
        this.N = A2.numCols;
        if (this.b.length < this.N) {
            this.b = new double[this.N];
            this.gammas = new double[this.N];
            this.u = new double[this.N];
        }
        return this._decompose();
    }

    @Override
    public boolean inputModified() {
        return true;
    }

    public DMatrixRMaj getQH() {
        return this.QH;
    }

    public DMatrixRMaj getH(DMatrixRMaj H) {
        H = UtilDecompositons_DDRM.checkZeros(H, this.N, this.N);
        System.arraycopy(this.QH.data, 0, H.data, 0, this.N);
        for (int i = 1; i < this.N; ++i) {
            for (int j = i - 1; j < this.N; ++j) {
                H.set(i, j, this.QH.get(i, j));
            }
        }
        return H;
    }

    public DMatrixRMaj getQ(DMatrixRMaj Q) {
        Q = UtilDecompositons_DDRM.checkIdentity(Q, this.N, this.N);
        for (int j = this.N - 2; j >= 0; --j) {
            this.u[j + 1] = 1.0;
            for (int i = j + 2; i < this.N; ++i) {
                this.u[i] = this.QH.get(i, j);
            }
            QrHelperFunctions_DDRM.rank1UpdateMultR(Q, this.u, this.gammas[j], j + 1, j + 1, this.N, this.b);
        }
        return Q;
    }

    private boolean _decompose() {
        double[] h2 = this.QH.data;
        for (int k = 0; k < this.N - 2; ++k) {
            double max = 0.0;
            for (int i = k + 1; i < this.N; ++i) {
                double val = this.u[i] = h2[i * this.N + k];
                if (!((val = Math.abs(val)) > max)) continue;
                max = val;
            }
            if (max > 0.0) {
                double gamma;
                double tau = 0.0;
                int i = k + 1;
                while (i < this.N) {
                    int n = i++;
                    double d = this.u[n] / max;
                    this.u[n] = d;
                    double val = d;
                    tau += val * val;
                }
                tau = Math.sqrt(tau);
                if (this.u[k + 1] < 0.0) {
                    tau = -tau;
                }
                double nu = this.u[k + 1] + tau;
                this.u[k + 1] = 1.0;
                for (int i2 = k + 2; i2 < this.N; ++i2) {
                    int n = i2;
                    double d = this.u[n] / nu;
                    this.u[n] = d;
                    h2[i2 * this.N + k] = d;
                }
                this.gammas[k] = gamma = nu / tau;
                QrHelperFunctions_DDRM.rank1UpdateMultR(this.QH, this.u, gamma, k + 1, k + 1, this.N, this.b);
                QrHelperFunctions_DDRM.rank1UpdateMultL(this.QH, this.u, gamma, 0, k + 1, this.N);
                h2[(k + 1) * this.N + k] = -tau * max;
                continue;
            }
            this.gammas[k] = 0.0;
        }
        return true;
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

