/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.UUID;
import junit.framework.TestCase;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class DataTestCase
extends TestCase {
    protected GeometryFactory gf;
    protected SimpleFeatureType roadType;
    protected SimpleFeatureType subRoadType;
    protected SimpleFeature[] roadFeatures;
    protected ReferencedEnvelope roadBounds;
    protected ReferencedEnvelope rd12Bounds;
    protected Filter rd1Filter;
    protected Filter rd2Filter;
    protected Filter rd12Filter;
    protected SimpleFeature newRoad;
    protected SimpleFeatureType riverType;
    protected SimpleFeatureType subRiverType;
    protected SimpleFeature[] riverFeatures;
    protected ReferencedEnvelope riverBounds;
    protected Filter rv1Filter;
    protected SimpleFeature newRiver;
    protected SimpleFeatureType lakeType;
    protected SimpleFeature[] lakeFeatures;
    protected ReferencedEnvelope lakeBounds;
    protected SimpleFeatureType invalidGeomType;
    protected SimpleFeature[] invalidGeomFeatures;
    protected ReferencedEnvelope invalidGeomBounds;
    protected SimpleFeatureType buildingType;
    protected SimpleFeature[] buildingFeatures;
    protected ReferencedEnvelope buildingBounds;
    protected FilterFactory2 ff;

    public DataTestCase(String name) {
        super(name);
    }

    protected int expected(Filter filter) {
        if (filter instanceof Id) {
            Id id = (Id)filter;
            return id.getIDs().size();
        }
        return -1;
    }

    protected void setUp() throws Exception {
        this.ff = CommonFactoryFinder.getFilterFactory2(null);
        this.dataSetUp();
    }

    protected void dataSetUp() throws Exception {
        String namespace = this.getName();
        this.roadType = DataUtilities.createType(namespace + ".road", "id:0,geom:LineString,name:String,uuid:UUID");
        this.subRoadType = DataUtilities.createType(namespace + "road", "id:0,geom:LineString");
        this.gf = new GeometryFactory();
        this.roadFeatures = new SimpleFeature[3];
        this.roadFeatures[0] = SimpleFeatureBuilder.build(this.roadType, new Object[]{new Integer(1), this.line(new int[]{1, 1, 2, 2, 4, 2, 5, 1}), "r1", UUID.randomUUID()}, "road.rd1");
        this.roadFeatures[1] = SimpleFeatureBuilder.build(this.roadType, new Object[]{new Integer(2), this.line(new int[]{3, 0, 3, 2, 3, 3, 3, 4}), "r2", UUID.randomUUID()}, "road.rd2");
        this.roadFeatures[2] = SimpleFeatureBuilder.build(this.roadType, new Object[]{new Integer(3), this.line(new int[]{3, 2, 4, 2, 5, 3}), "r3", UUID.randomUUID()}, "road.rd3");
        this.roadBounds = new ReferencedEnvelope();
        this.roadBounds.expandToInclude(new ReferencedEnvelope(this.roadFeatures[0].getBounds()));
        this.roadBounds.expandToInclude(new ReferencedEnvelope(this.roadFeatures[1].getBounds()));
        this.roadBounds.expandToInclude(new ReferencedEnvelope(this.roadFeatures[2].getBounds()));
        this.rd1Filter = this.ff.id(Collections.singleton(this.ff.featureId("road.rd1")));
        this.rd2Filter = this.ff.id(Collections.singleton(this.ff.featureId("road.rd2")));
        Id create = this.ff.id(new HashSet<FeatureId>(Arrays.asList(this.ff.featureId("road.rd1"), this.ff.featureId("road.rd2"))));
        this.rd12Filter = create;
        this.rd12Bounds = new ReferencedEnvelope();
        this.rd12Bounds.expandToInclude(new ReferencedEnvelope(this.roadFeatures[0].getBounds()));
        this.rd12Bounds.expandToInclude(new ReferencedEnvelope(this.roadFeatures[1].getBounds()));
        this.newRoad = SimpleFeatureBuilder.build(this.roadType, new Object[]{new Integer(4), this.line(new int[]{1, 2, 2, 3}), "r4", UUID.randomUUID()}, "road.rd4");
        this.riverType = DataUtilities.createType(namespace + ".river", "id:0,geom:MultiLineString,river:String,flow:0.0");
        this.subRiverType = DataUtilities.createType(namespace + ".river", "river:String,flow:0.0");
        this.gf = new GeometryFactory();
        this.riverFeatures = new SimpleFeature[2];
        this.riverFeatures[0] = SimpleFeatureBuilder.build(this.riverType, new Object[]{new Integer(1), this.lines(new int[][]{{5, 5, 7, 4}, {7, 5, 9, 7, 13, 7}, {7, 5, 9, 3, 11, 3}}), "rv1", new Double(4.5)}, "river.rv1");
        this.riverFeatures[1] = SimpleFeatureBuilder.build(this.riverType, new Object[]{new Integer(2), this.lines(new int[][]{{4, 6, 4, 8, 6, 10}}), "rv2", new Double(3.0)}, "river.rv2");
        this.riverBounds = new ReferencedEnvelope();
        this.riverBounds.expandToInclude(ReferencedEnvelope.reference(this.riverFeatures[0].getBounds()));
        this.riverBounds.expandToInclude(ReferencedEnvelope.reference(this.riverFeatures[1].getBounds()));
        this.rv1Filter = this.ff.id(Collections.singleton(this.ff.featureId("river.rv1")));
        this.newRiver = SimpleFeatureBuilder.build(this.riverType, new Object[]{new Integer(3), this.lines(new int[][]{{9, 5, 11, 5, 13, 3}}), "rv3", new Double(1.5)}, "river.rv3");
        this.lakeType = DataUtilities.createType(namespace + ".lake", "id:0,geom:Polygon:nillable,name:String");
        this.lakeFeatures = new SimpleFeature[1];
        this.lakeFeatures[0] = SimpleFeatureBuilder.build(this.lakeType, new Object[]{new Integer(0), this.polygon(new int[]{12, 6, 14, 8, 16, 6, 16, 4, 14, 4, 12, 6}), "muddy"}, "lake.lk1");
        this.lakeBounds = new ReferencedEnvelope();
        this.lakeBounds.expandToInclude(ReferencedEnvelope.reference(this.lakeFeatures[0].getBounds()));
        this.invalidGeomType = DataUtilities.createType(namespace + ".invalid", "id:0,geom:Polygon:nillable,name:String");
        this.invalidGeomFeatures = new SimpleFeature[1];
        this.invalidGeomFeatures[0] = SimpleFeatureBuilder.build(this.invalidGeomType, new Object[]{new Integer(0), this.polygon(new int[]{12, 6, 14, 8, 16, 6, 12, 8, 12, 6}), "notvalid"}, "invalid.inv1");
        this.invalidGeomBounds = new ReferencedEnvelope();
        this.buildingType = DataUtilities.createType(namespace + ".building", "id:0,geom:Polygon:nillable,name:String");
        this.buildingFeatures = new SimpleFeature[1];
        this.buildingFeatures[0] = SimpleFeatureBuilder.build(this.lakeType, new Object[]{new Integer(0), this.polygon(new int[]{12, 6, 14, 8, 16, 6, 16, 4, 12, 4, 12, 6}), "church"}, "building.bd1");
        this.buildingBounds = new ReferencedEnvelope();
        this.buildingBounds.expandToInclude(ReferencedEnvelope.reference(this.buildingFeatures[0].getBounds()));
    }

    protected void tearDown() throws Exception {
        this.gf = null;
        this.roadType = null;
        this.subRoadType = null;
        this.roadFeatures = null;
        this.roadBounds = null;
        this.rd1Filter = null;
        this.rd2Filter = null;
        this.newRoad = null;
        this.riverType = null;
        this.subRiverType = null;
        this.riverFeatures = null;
        this.riverBounds = null;
        this.rv1Filter = null;
        this.newRiver = null;
        this.buildingType = null;
        this.buildingFeatures = null;
        this.buildingBounds = null;
    }

    public LineString line(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate(xy[i], xy[i + 1]);
        }
        return this.gf.createLineString(coords);
    }

    public MultiLineString lines(int[][] xy) {
        LineString[] lines = new LineString[xy.length];
        for (int i = 0; i < xy.length; ++i) {
            lines[i] = this.line(xy[i]);
        }
        return this.gf.createMultiLineString(lines);
    }

    public Polygon polygon(int[] xy) {
        LinearRing shell = this.ring(xy);
        return this.gf.createPolygon(shell, null);
    }

    public Polygon polygon(int[] xy, int[][] holes) {
        if (holes == null || holes.length == 0) {
            return this.polygon(xy);
        }
        LinearRing shell = this.ring(xy);
        LinearRing[] rings = new LinearRing[holes.length];
        for (int i = 0; i < xy.length; ++i) {
            rings[i] = this.ring(holes[i]);
        }
        return this.gf.createPolygon(shell, rings);
    }

    public LinearRing ring(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate(xy[i], xy[i + 1]);
        }
        return this.gf.createLinearRing(coords);
    }

    protected void assertEquals(Geometry expected, Geometry actual) {
        if (expected == actual) {
            return;
        }
        DataTestCase.assertNotNull((Object)expected);
        DataTestCase.assertNotNull((Object)actual);
        DataTestCase.assertTrue((boolean)expected.equalsExact(actual));
    }

    protected void assertEquals(String message, Geometry expected, Geometry actual) {
        if (expected == actual) {
            return;
        }
        DataTestCase.assertNotNull((String)message, (Object)expected);
        DataTestCase.assertNotNull((String)message, (Object)actual);
        DataTestCase.assertTrue((String)message, (boolean)expected.equalsExact(actual));
    }

    protected int count(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        if (reader == null) {
            return -1;
        }
        int count = 0;
        try {
            while (reader.hasNext()) {
                reader.next();
                ++count;
            }
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("hasNext() lied to me at:" + count, e);
        }
        catch (Exception e) {
            throw new DataSourceException("next() could not understand feature at:" + count, e);
        }
        finally {
            reader.close();
        }
        return count;
    }

    protected int count(FeatureWriter<SimpleFeatureType, SimpleFeature> writer) throws NoSuchElementException, IOException {
        int count = 0;
        try {
            while (writer.hasNext()) {
                writer.next();
                ++count;
            }
        }
        finally {
            writer.close();
        }
        return count;
    }
}

