/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.logging.Level;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.RangedClassifier;
import org.opengis.filter.capability.FunctionName;

public class StandardDeviationFunction
extends ClassificationFunction {
    public static FunctionName NAME = new FunctionNameImpl("StandardDeviation", RangedClassifier.class, FunctionNameImpl.parameter("value", Double.class), FunctionNameImpl.parameter("classes", Integer.class));

    public StandardDeviationFunction() {
        super(NAME);
    }

    private Object calculate(SimpleFeatureCollection featureCollection) {
        try {
            int classNum = this.getClasses();
            StandardDeviationVisitor sdVisit = new StandardDeviationVisitor(this.getParameters().get(0));
            featureCollection.accepts(sdVisit, this.progress);
            if (this.progress != null && this.progress.isCanceled()) {
                return null;
            }
            CalcResult calcResult = sdVisit.getResult();
            if (calcResult == null) {
                return null;
            }
            double standardDeviation = calcResult.toDouble();
            Comparable[] min2 = new Double[classNum];
            Comparable[] max = new Double[classNum];
            for (int i = 0; i < classNum; ++i) {
                min2[i] = this.getMin(i, classNum, sdVisit.getMean(), standardDeviation);
                max[i] = this.getMax(i, classNum, sdVisit.getMean(), standardDeviation);
            }
            return new RangedClassifier(min2, max);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "StandardDeviationFunction calculate failed", e);
            return null;
        }
    }

    @Override
    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)feature);
    }

    private Double getMin(int index, int numClasses, double average, double standardDeviation) {
        if (index <= 0 || index >= numClasses) {
            return null;
        }
        return new Double(average - ((double)numClasses / 2.0 - (double)index) * standardDeviation);
    }

    private Double getMax(int index, int numClasses, double average, double standardDeviation) {
        if (index < 0 || index >= numClasses - 1) {
            return null;
        }
        return new Double(average - ((double)numClasses / 2.0 - 1.0 - (double)index) * standardDeviation);
    }
}

