/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

final class GMLUtils {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.gml.producer");
    public static final String GML_URL = "http://www.opengis.net/gml";
    protected static final int POINT = 1;
    protected static final int LINESTRING = 2;
    protected static final int POLYGON = 3;
    protected static final int MULTIPOINT = 4;
    protected static final int MULTILINESTRING = 5;
    protected static final int MULTIPOLYGON = 6;
    protected static final int MULTIGEOMETRY = 7;

    private GMLUtils() {
    }

    public static String getGeometryName(Geometry geometry) {
        LOGGER.entering("GMLUtils", "getGeometryName", geometry);
        String returnValue = null;
        returnValue = geometry instanceof Point ? "Point" : (geometry instanceof LineString ? "LineString" : (geometry instanceof Polygon ? "Polygon" : (geometry instanceof MultiPoint ? "MultiPoint" : (geometry instanceof MultiLineString ? "MultiLineString" : (geometry instanceof MultiPolygon ? "MultiPolygon" : (geometry instanceof GeometryCollection ? "GeometryCollection" : null))))));
        LOGGER.exiting("GMLUtils", "getGeometryName", returnValue);
        return returnValue;
    }

    public static int getGeometryType(Geometry geometry) {
        int returnValue = -1;
        returnValue = geometry instanceof Point ? 1 : (geometry instanceof LineString ? 2 : (geometry instanceof Polygon ? 3 : (geometry instanceof MultiPoint ? 4 : (geometry instanceof MultiLineString ? 5 : (geometry instanceof MultiPolygon ? 6 : (geometry instanceof GeometryCollection ? 7 : -1))))));
        return returnValue;
    }

    public static String getMemberName(int geometryType) {
        switch (geometryType) {
            case 4: {
                return "pointMember";
            }
            case 5: {
                return "lineStringMember";
            }
            case 6: {
                return "polygonMember";
            }
        }
        return "geometryMember";
    }

    public static String encodeXML(String inData) {
        if (inData == null) {
            return null;
        }
        if (inData.indexOf(38) == -1 && inData.indexOf(60) == -1 && inData.indexOf(62) == -1 && inData.indexOf(39) == -1 && inData.indexOf(34) == -1) {
            return inData;
        }
        int length = inData.length();
        StringBuffer buffer = new StringBuffer(2 * length);
        for (int i = 0; i < length; ++i) {
            char charToCompare = inData.charAt(i);
            if (charToCompare == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (charToCompare == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (charToCompare == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (charToCompare == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (charToCompare == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(charToCompare);
        }
        return buffer.toString();
    }
}

