/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractConverter;

class SexagesimalConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3873494343412121773L;
    private static final double EPS = 1.0E-8;
    static final SexagesimalConverter INTEGER = new SexagesimalConverter(1);
    static final SexagesimalConverter FRACTIONAL = new SexagesimalConverter(10000);
    final int divider;
    private final SexagesimalConverter inverse;

    private SexagesimalConverter(int divider) {
        this.divider = divider;
        this.inverse = new Inverse(this);
    }

    private SexagesimalConverter(int divider, SexagesimalConverter inverse) {
        this.divider = divider;
        this.inverse = inverse;
    }

    @Override
    public final SexagesimalConverter inverse() {
        return this.inverse;
    }

    @Override
    public double convert(double value) {
        int deg = (int)value;
        value = (value - (double)deg) * 60.0;
        int min2 = (int)value;
        value = (value - (double)min2) * 60.0;
        int sec = (int)value;
        return ((double)((deg * 100 + min2) * 100 + sec) + (value -= (double)sec)) / (double)this.divider;
    }

    public final double derivative(double x) {
        return 1.0;
    }

    @Override
    public final boolean isLinear() {
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && ((SexagesimalConverter)object).divider == this.divider;
    }

    @Override
    public int hashCode() {
        return 714113197 + this.divider;
    }

    protected Object readResolve() throws ObjectStreamException {
        UnitConverter candidate = INTEGER;
        for (int i = 0; i <= 3; ++i) {
            switch (i) {
                case 0: {
                    break;
                }
                case 2: {
                    candidate = FRACTIONAL;
                    break;
                }
                default: {
                    candidate = candidate.inverse();
                }
            }
            if (!this.equals(candidate)) continue;
            return candidate;
        }
        return this;
    }

    @Override
    public Number convert(Number value) {
        return this.convert(value);
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        double valueAsDouble = value.doubleValue();
        if (valueAsDouble == Double.NEGATIVE_INFINITY || valueAsDouble == Double.POSITIVE_INFINITY) {
            throw new ArithmeticException("Bigdecimal value magnitude too great to fit in double: " + value);
        }
        return new BigDecimal(this.convert(valueAsDouble));
    }

    private static final class Inverse
    extends SexagesimalConverter {
        private static final long serialVersionUID = -7171869900634417819L;

        public Inverse(SexagesimalConverter inverse) {
            super(inverse.divider, inverse);
        }

        @Override
        public double convert(double value) {
            int deg = (int)((value *= (double)this.divider) / 10000.0);
            int min2 = (int)((value -= (double)(10000 * deg)) / 100.0);
            value -= (double)(100 * min2);
            if (min2 <= -60 || min2 >= 60) {
                if ((double)Math.abs(Math.abs(min2) - 100) <= 1.0E-8) {
                    deg = min2 >= 0 ? ++deg : --deg;
                    min2 = 0;
                } else {
                    throw new ArithmeticException("Invalid minutes: " + min2);
                }
            }
            if (value <= -60.0 || value >= 60.0) {
                if (Math.abs(Math.abs(value) - 100.0) <= 1.0E-8) {
                    min2 = value >= 0.0 ? ++min2 : --min2;
                    value = 0.0;
                } else {
                    throw new ArithmeticException("Invalid secondes: " + value);
                }
            }
            value = (value / 60.0 + (double)min2) / 60.0 + (double)deg;
            return value;
        }

        @Override
        public int hashCode() {
            return -715221659 + this.divider;
        }
    }
}

