/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import java.util.Set;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.Hints;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;

public class BufferedCoordinateOperationFactory
extends AbstractCoordinateOperationFactory
implements BufferedFactory {
    static final int PRIORITY = 70;
    private volatile CoordinateOperationFactory factory;
    private final Map<CRSPair, CoordinateOperation> pool = new SoftValueHashMap<CRSPair, CoordinateOperation>();

    public BufferedCoordinateOperationFactory() {
        super(null, 70);
    }

    public BufferedCoordinateOperationFactory(Hints userHints) {
        this(userHints, 70);
    }

    public BufferedCoordinateOperationFactory(Hints userHints, int priority) {
        this(BufferedCoordinateOperationFactory.getBackingFactory(userHints), userHints, priority);
    }

    public BufferedCoordinateOperationFactory(CoordinateOperationFactory factory, int priority) {
        this(factory, null, priority);
    }

    private BufferedCoordinateOperationFactory(CoordinateOperationFactory factory, Hints userHints, int priority) {
        super(factory, userHints, priority);
        this.factory = factory;
        BufferedCoordinateOperationFactory.ensureNonNull("factory", factory);
    }

    private static CoordinateOperationFactory getBackingFactory(Hints hints) {
        for (CoordinateOperationFactory candidate : ReferencingFactoryFinder.getCoordinateOperationFactories(hints)) {
            if (candidate instanceof BufferedCoordinateOperationFactory) continue;
            return candidate;
        }
        return ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CoordinateOperationFactory getBackingFactory() {
        if (this.factory == null) {
            BufferedCoordinateOperationFactory bufferedCoordinateOperationFactory = this;
            synchronized (bufferedCoordinateOperationFactory) {
                if (this.factory == null) {
                    this.factory = BufferedCoordinateOperationFactory.getBackingFactory(null);
                }
            }
        }
        return this.factory;
    }

    @Override
    void initializeHints() {
        super.initializeHints();
        this.hints.put(Hints.COORDINATE_OPERATION_FACTORY, this.getBackingFactory());
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        BufferedCoordinateOperationFactory.ensureNonNull("sourceCRS", sourceCRS);
        BufferedCoordinateOperationFactory.ensureNonNull("targetCRS", targetCRS);
        CRSPair key = new CRSPair(sourceCRS, targetCRS);
        CoordinateOperation op = this.pool.get(key);
        if (op == null) {
            op = this.getBackingFactory().createOperation(sourceCRS, targetCRS);
            this.pool.put(key, op);
        }
        return op;
    }

    @Override
    public Set<CoordinateOperation> findOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        BufferedCoordinateOperationFactory.ensureNonNull("sourceCRS", sourceCRS);
        BufferedCoordinateOperationFactory.ensureNonNull("targetCRS", targetCRS);
        return this.getBackingFactory().findOperations(sourceCRS, targetCRS);
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, OperationMethod method) throws OperationNotFoundException, FactoryException {
        return this.getBackingFactory().createOperation(sourceCRS, targetCRS, method);
    }

    private static final class CRSPair {
        private final int hash;
        private final CoordinateReferenceSystem sourceCRS;
        private final CoordinateReferenceSystem targetCRS;

        public CRSPair(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
            this.sourceCRS = sourceCRS;
            this.targetCRS = targetCRS;
            this.hash = 37 * sourceCRS.hashCode() + targetCRS.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CRSPair) {
                CRSPair that = (CRSPair)object;
                return Utilities.equals(this.sourceCRS, that.sourceCRS) && Utilities.equals(this.targetCRS, that.targetCRS);
            }
            return false;
        }
    }
}

