/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.ParameterWriter;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.MathTransformParser;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.Arguments;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.LazySet;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CanonicalSet;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

public class DefaultMathTransformFactory
extends ReferencingFactory
implements MathTransformFactory {
    private static final Hints HINTS = null;
    private transient MathTransformParser parser;
    private transient MathTransformProvider lastProvider;
    private static final ThreadLocal<OperationMethod> lastMethod = new ThreadLocal();
    private final CanonicalSet<MathTransform> pool;
    private final FactoryRegistry registry;

    public DefaultMathTransformFactory() {
        this(new Class[]{MathTransformProvider.class});
    }

    private DefaultMathTransformFactory(Class<?>[] categories) {
        this.registry = new FactoryRegistry(Arrays.asList(categories));
        this.pool = CanonicalSet.newInstance(MathTransform.class);
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    @Override
    public Set<OperationMethod> getAvailableMethods(Class<? extends Operation> type) {
        return new LazySet<OperationMethod>(this.registry.getFactories(MathTransformProvider.class, type != null ? new MethodFilter(type) : null, HINTS));
    }

    @Override
    public OperationMethod getLastMethodUsed() {
        return lastMethod.get();
    }

    public OperationMethod getOperationMethod(String name) throws NoSuchIdentifierException {
        return this.getProvider(name);
    }

    private MathTransformProvider getProvider(String method) throws NoSuchIdentifierException {
        MathTransformProvider provider = this.lastProvider;
        if (provider != null && provider.nameMatches(method)) {
            return provider;
        }
        this.lastProvider = provider = this.registry.getFactories(MathTransformProvider.class, null, HINTS).filter(prov -> prov.nameMatches(method)).findAny().orElseThrow(() -> new NoSuchIdentifierException(Errors.format(141, method), method));
        return this.lastProvider;
    }

    @Override
    public ParameterValueGroup getDefaultParameters(String method) throws NoSuchIdentifierException {
        return this.getProvider(method).getParameters().createValue();
    }

    @Override
    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS) throws NoSuchIdentifierException, FactoryException {
        Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(baseCRS);
        if (ellipsoid != null) {
            Unit<Length> axisUnit = ellipsoid.getAxisUnit();
            Parameters.ensureSet(parameters, "semi_major", ellipsoid.getSemiMajorAxis(), axisUnit, false);
            Parameters.ensureSet(parameters, "semi_minor", ellipsoid.getSemiMinorAxis(), axisUnit, false);
        }
        MathTransform baseToDerived = this.createParameterizedTransform(parameters);
        OperationMethod method = lastMethod.get();
        baseToDerived = this.createBaseToDerived(baseCRS, baseToDerived, derivedCS);
        lastMethod.set(method);
        return baseToDerived;
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, MathTransform projection, CoordinateSystem derivedCS) throws FactoryException {
        int targetDim;
        int sourceDim;
        Matrix swap3;
        Matrix swap1;
        CoordinateSystem sourceCS = baseCRS.getCoordinateSystem();
        try {
            swap1 = AbstractCS.swapAndScaleAxis(sourceCS, AbstractCS.standard(sourceCS));
            swap3 = AbstractCS.swapAndScaleAxis(AbstractCS.standard(derivedCS), derivedCS);
        }
        catch (IllegalArgumentException cause) {
            throw new FactoryException(cause);
        }
        MathTransform step1 = this.createAffineTransform(swap1);
        MathTransform step3 = this.createAffineTransform(swap3);
        MathTransform step2 = projection;
        int numTrailingOrdinates = step3.getSourceDimensions() - step2.getTargetDimensions();
        if (numTrailingOrdinates > 0) {
            step2 = this.createPassThroughTransform(0, step2, numTrailingOrdinates);
        }
        if ((sourceDim = step1.getTargetDimensions()) > (targetDim = step2.getSourceDimensions())) {
            XMatrix drop = MatrixFactory.create(targetDim + 1, sourceDim + 1);
            drop.setElement(targetDim, sourceDim, 1.0);
            step1 = this.createConcatenatedTransform(this.createAffineTransform(drop), step1);
        }
        return this.createConcatenatedTransform(this.createConcatenatedTransform(step1, step2), step3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform createParameterizedTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform;
        OperationMethod method = null;
        try {
            MathTransformProvider provider;
            String classification = parameters.getDescriptor().getName().getCode();
            method = provider = this.getProvider(classification);
            try {
                parameters = provider.ensureValidValues(parameters);
                transform = provider.createMathTransform(parameters);
            }
            catch (IllegalArgumentException exception) {
                throw new FactoryException(exception);
            }
            if (transform instanceof MathTransformProvider.Delegate) {
                MathTransformProvider.Delegate delegate = (MathTransformProvider.Delegate)transform;
                method = delegate.method;
                transform = delegate.transform;
            }
            transform = this.pool.unique(transform);
            lastMethod.set(method);
        }
        catch (Throwable throwable) {
            lastMethod.set(method);
            throw throwable;
        }
        return transform;
    }

    @Override
    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        lastMethod.remove();
        return this.pool.unique(ProjectiveTransform.create(matrix));
    }

    @Override
    public MathTransform createConcatenatedTransform(MathTransform transform1, MathTransform transform2) throws FactoryException {
        MathTransform tr;
        try {
            tr = ConcatenatedTransform.create(transform1, transform2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        tr = this.pool.unique(tr);
        return tr;
    }

    @Override
    public MathTransform createPassThroughTransform(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) throws FactoryException {
        MathTransform tr;
        try {
            tr = PassThroughTransform.create(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        tr = this.pool.unique(tr);
        return tr;
    }

    @Override
    public MathTransform createFromXML(String xml) throws FactoryException {
        throw new FactoryException("Not yet implemented.");
    }

    @Override
    public synchronized MathTransform createFromWKT(String text) throws FactoryException {
        if (this.parser == null) {
            this.parser = new MathTransformParser(Symbols.DEFAULT, this);
        }
        try {
            return this.parser.parseMathTransform(text);
        }
        catch (ParseException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception);
        }
    }

    public void scanForPlugins() {
        this.registry.scanForPlugins();
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        boolean printAll = arguments.getFlag("-all");
        Class type = null;
        if (arguments.getFlag("-projections")) {
            type = Projection.class;
        }
        if (arguments.getFlag("-conversions")) {
            type = Conversion.class;
        }
        args = arguments.getRemainingArguments(1);
        try {
            DefaultMathTransformFactory factory = new DefaultMathTransformFactory();
            ParameterWriter writer = new ParameterWriter(arguments.out);
            writer.setLocale(arguments.locale);
            Set<Object> methods = Collections.emptySet();
            if (printAll || args.length == 0) {
                HashSet<String> scopes = new HashSet<String>();
                scopes.add("EPSG");
                scopes.add("Geotools");
                methods = new TreeSet<IdentifiedObject>(AbstractIdentifiedObject.NAME_COMPARATOR);
                methods.addAll(factory.getAvailableMethods(type));
                writer.summary(methods, scopes);
            }
            if (!printAll) {
                methods = args.length == 0 ? Collections.emptySet() : Collections.singleton(factory.getProvider(args[0]));
            }
            String lineSeparator = System.getProperty("line.separator", "\n");
            for (OperationMethod operationMethod : methods) {
                arguments.out.write(lineSeparator);
                writer.format(operationMethod);
            }
        }
        catch (NoSuchIdentifierException exception) {
            arguments.err.println(exception.getLocalizedMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(arguments.err);
            return;
        }
        arguments.out.flush();
    }

    public static void cleanupThreadLocals() {
        lastMethod.remove();
    }

    private static final class MethodFilter
    implements Predicate<MathTransformProvider> {
        private final Class<? extends Operation> type;

        public MethodFilter(Class<? extends Operation> type) {
            this.type = type;
        }

        @Override
        public boolean test(MathTransformProvider element) {
            Class<? extends Operation> t;
            return !(element instanceof MathTransformProvider) || (t = element.getOperationType()) == null || this.type.isAssignableFrom(t);
        }
    }
}

