/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;

public class CassiniSoldner
extends MapProjection {
    private static final int MAXIMUM_ITERATIONS = 15;
    private final double ml0;
    private static final double C1 = 0.16666666666666666;
    private static final double C2 = 0.008333333333333333;
    private static final double C3 = 0.041666666666666664;
    private static final double C4 = 0.3333333333333333;
    private static final double C5 = 0.06666666666666667;

    protected CassiniSoldner(ParameterValueGroup values) throws ParameterNotFoundException {
        super(values);
        this.ml0 = this.mlfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin), Math.cos(this.latitudeOfOrigin));
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double ph1 = this.inv_mlfn(this.ml0 + y);
        double tn = Math.tan(ph1);
        double t = tn * tn;
        double n = Math.sin(ph1);
        double r = 1.0 / (1.0 - this.excentricitySquared * n * n);
        n = Math.sqrt(r);
        double dd = x / n;
        double d2 = dd * dd;
        double phi = ph1 - n * tn / (r *= (1.0 - this.excentricitySquared) * n) * d2 * (0.5 - (1.0 + 3.0 * t) * d2 * 0.041666666666666664);
        double lam = dd * (1.0 + t * d2 * (-0.3333333333333333 + (1.0 + 3.0 * t) * d2 * 0.06666666666666667)) / Math.cos(ph1);
        if (ptDst != null) {
            ptDst.setLocation(lam, phi);
            return ptDst;
        }
        return new Point2D.Double(lam, phi);
    }

    @Override
    protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
        double sinphi = Math.sin(phi);
        double cosphi = Math.cos(phi);
        double n = 1.0 / Math.sqrt(1.0 - this.excentricitySquared * sinphi * sinphi);
        double tn = Math.tan(phi);
        double t = tn * tn;
        double a1 = lam * cosphi;
        double c = cosphi * cosphi * this.excentricitySquared / (1.0 - this.excentricitySquared);
        double a2 = a1 * a1;
        double x = n * a1 * (1.0 - a2 * t * (0.16666666666666666 - (8.0 - t + 8.0 * c) * a2 * 0.008333333333333333));
        double y = this.mlfn(phi, sinphi, cosphi) - this.ml0 + n * tn * a2 * (0.5 + (5.0 - t + 6.0 * c) * a2 * 0.041666666666666664);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Cassini_Soldner"), new NamedIdentifier(Citations.EPSG, "Cassini-Soldner"), new NamedIdentifier(Citations.EPSG, "9806"), new NamedIdentifier(Citations.GEOTIFF, "CT_CassiniSoldner"), new NamedIdentifier(Citations.ESRI, "Cassini"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(249))});

        static ParameterDescriptorGroup createDescriptorGroup(ReferenceIdentifier[] identifiers) {
            return Provider.createDescriptorGroup(identifiers, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});
        }

        public Provider() {
            super(PARAMETERS);
        }

        Provider(ParameterDescriptorGroup descriptor) {
            super(descriptor);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters);
            }
            return new CassiniSoldner(parameters);
        }
    }

    private static final class Spherical
    extends CassiniSoldner {
        protected Spherical(ParameterValueGroup values) throws ParameterNotFoundException {
            super(values);
            assert (this.isSpherical);
        }

        @Override
        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double x1 = Math.asin(Math.cos(y) * Math.sin(x));
            double y1 = Math.atan2(Math.tan(y), Math.cos(x)) - this.latitudeOfOrigin;
            if (ptDst != null) {
                ptDst.setLocation(x1, y1);
                return ptDst;
            }
            return new Point2D.Double(x1, y1);
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double dd = y + this.latitudeOfOrigin;
            double phi = Math.asin(Math.sin(dd) * Math.cos(x));
            double lam = Math.atan2(Math.tan(x), Math.cos(dd));
            if (ptDst != null) {
                ptDst.setLocation(lam, phi);
                return ptDst;
            }
            return new Point2D.Double(lam, phi);
        }
    }
}

