/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryDimensionCollector
implements GeometryComponentFilter {
    int targetDimension;
    List<Geometry> geometries = new ArrayList<Geometry>();

    public GeometryDimensionCollector(int targetDimension) {
        this.targetDimension = targetDimension;
    }

    @Override
    public void filter(Geometry geom) {
        if (!(geom instanceof GeometryCollection) && geom.getDimension() == this.targetDimension && !geom.isEmpty()) {
            this.geometries.add(geom);
        }
    }

    public Geometry collect() {
        if (this.geometries.isEmpty()) {
            return null;
        }
        if (this.geometries.size() == 1) {
            return this.geometries.get(0);
        }
        GeometryFactory factory = this.geometries.get(0).getFactory();
        if (this.targetDimension == 0) {
            return factory.createMultiPoint(this.geometries.toArray(new Point[this.geometries.size()]));
        }
        if (this.targetDimension == 1) {
            return factory.createMultiLineString(this.geometries.toArray(new LineString[this.geometries.size()]));
        }
        if (this.targetDimension == 2) {
            return factory.createMultiPolygon(this.geometries.toArray(new Polygon[this.geometries.size()]));
        }
        return null;
    }
}

