/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.geotools.util.logging.LoggerAdapter;

final class Log4JLogger
extends LoggerAdapter {
    final Logger logger;

    public Log4JLogger(String name, Logger logger2) {
        super(name);
        this.logger = logger2;
    }

    private static Level toLog4JLevel(java.util.logging.Level level) {
        int n = level.intValue();
        switch (n / 100) {
            default: {
                switch (n) {
                    default: {
                        if (n >= 0) {
                            return Level.FATAL;
                        }
                    }
                    case -2147483648: {
                        return Level.ALL;
                    }
                    case 0x7FFFFFFF: 
                }
                return Level.OFF;
            }
            case 10: {
                return Level.ERROR;
            }
            case 9: {
                return Level.WARN;
            }
            case 7: 
            case 8: {
                return Level.INFO;
            }
            case 5: 
            case 6: {
                return Level.DEBUG;
            }
            case 4: {
                return Level.TRACE;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
        }
        return Level.ALL;
    }

    private static java.util.logging.Level toJavaLevel(Level level) {
        int n = level.toInt();
        if (n == Integer.MAX_VALUE) {
            return java.util.logging.Level.OFF;
        }
        if (n >= 40000) {
            return java.util.logging.Level.SEVERE;
        }
        if (n >= 30000) {
            return java.util.logging.Level.WARNING;
        }
        if (n >= 20000) {
            return java.util.logging.Level.CONFIG;
        }
        if (n >= 10000) {
            return java.util.logging.Level.FINE;
        }
        if (n >= 5000) {
            return java.util.logging.Level.FINER;
        }
        return java.util.logging.Level.ALL;
    }

    @Override
    public void setLevel(java.util.logging.Level level) {
        this.logger.setLevel(Log4JLogger.toLog4JLevel(level));
    }

    @Override
    public java.util.logging.Level getLevel() {
        return Log4JLogger.toJavaLevel(this.logger.getEffectiveLevel());
    }

    @Override
    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabledFor(Log4JLogger.toLog4JLevel(level));
    }

    @Override
    public void log(java.util.logging.Level level, String message) {
        this.logger.log(Log4JLogger.toLog4JLevel(level), message);
    }

    @Override
    public void log(java.util.logging.Level level, String message, Throwable thrown) {
        this.logger.log(Log4JLogger.toLog4JLevel(level), message, thrown);
    }

    @Override
    public void severe(String message) {
        this.logger.error(message);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(message);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void config(String message) {
        this.logger.info(message);
    }

    @Override
    public void fine(String message) {
        this.logger.debug(message);
    }

    @Override
    public void finer(String message) {
        this.logger.debug(message);
    }

    @Override
    public void finest(String message) {
        this.logger.trace(message);
    }
}

