/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Logger;
import org.geotools.util.WeakValueHashMap;

public abstract class LoggerFactory<L> {
    private final Class<L> loggerClass;
    private final WeakValueHashMap<String, Logger> loggers;

    protected LoggerFactory(Class<L> loggerClass) {
        this.loggerClass = loggerClass;
        this.loggers = new WeakValueHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String name) {
        L target = this.getImplementation(name);
        if (target == null) {
            return null;
        }
        WeakValueHashMap<String, Logger> weakValueHashMap = this.loggers;
        synchronized (weakValueHashMap) {
            Logger logger2 = this.loggers.get(name);
            if (logger2 == null || !target.equals(this.unwrap(logger2))) {
                logger2 = this.wrap(name, target);
                this.loggers.put(name, logger2);
            }
            return logger2;
        }
    }

    public Class<L> getImplementationClass() {
        return this.loggerClass;
    }

    protected abstract L getImplementation(String var1);

    protected abstract Logger wrap(String var1, L var2);

    protected abstract L unwrap(Logger var1);
}

