/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks.annotationparameters;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersAbstractCheck;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class AnnotationParametersGroupsCheck
extends AnnotationParametersAbstractCheck {
    public AnnotationParametersGroupsCheck(AnnotationApiHelper annotationApiHelper) {
        super(annotationApiHelper, new String[0]);
    }

    @Override
    protected boolean canCheckThisAnnotation(AnnotationMirror annotation) {
        return true;
    }

    @Override
    protected Set<ConstraintCheckIssue> doCheck(Element element, AnnotationMirror annotation) {
        List<? extends AnnotationValue> annotationValue = this.annotationApiHelper.getAnnotationArrayValue(annotation, "groups");
        HashSet<ConstraintCheckIssue> issues = CollectionHelper.newHashSet();
        for (AnnotationValue annotationValue2 : annotationValue) {
            if (this.annotationApiHelper.isInterface((TypeMirror)annotationValue2.getValue())) continue;
            issues.add(ConstraintCheckIssue.error(element, annotation, "INVALID_GROUPS_VALUE_ANNOTATION_PARAMETERS", new Object[0]));
        }
        return issues;
    }
}

