/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.classchecks;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.classchecks.AbstractMethodOverrideCheck;
import org.hibernate.validator.ap.internal.classchecks.MethodInheritanceTree;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.ConstraintHelper;

public class ReturnValueMethodOverrideCheck
extends AbstractMethodOverrideCheck {
    public ReturnValueMethodOverrideCheck(Elements elementUtils, Types typeUtils, ConstraintHelper constraintHelper) {
        super(elementUtils, typeUtils, constraintHelper);
    }

    @Override
    protected Set<ConstraintCheckIssue> checkMethodInternal(ExecutableElement currentMethod, MethodInheritanceTree methodInheritanceTree) {
        HashSet<ConstraintCheckIssue> issues = CollectionHelper.newHashSet();
        for (ExecutableElement overriddenMethod : methodInheritanceTree.getOverriddenMethods()) {
            if (!this.methodIsAnnotatedWithValid(overriddenMethod)) continue;
            issues.add(ConstraintCheckIssue.error(currentMethod, null, "INCORRECT_METHOD_RETURN_VALUE_OVERRIDING", this.getEnclosingTypeElementQualifiedName(overriddenMethod)));
        }
        return issues;
    }

    @Override
    protected boolean needToPerformAnyChecks(ExecutableElement currentMethod) {
        return !currentMethod.getReturnType().getKind().equals((Object)TypeKind.VOID) && this.methodIsAnnotatedWithValid(currentMethod);
    }

    private boolean methodIsAnnotatedWithValid(ExecutableElement method) {
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            if (!ConstraintHelper.AnnotationType.GRAPH_VALIDATION_ANNOTATION.equals((Object)this.constraintHelper.getAnnotationType(annotationMirror))) continue;
            return true;
        }
        return false;
    }
}

