/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorDescriptor;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorManager;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.NewJaxbContext;
import org.hibernate.validator.internal.util.privilegedactions.SetContextClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.Unmarshal;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.CloseIgnoringInputStream;
import org.hibernate.validator.internal.xml.ConstrainedExecutableBuilder;
import org.hibernate.validator.internal.xml.ConstrainedFieldBuilder;
import org.hibernate.validator.internal.xml.ConstrainedGetterBuilder;
import org.hibernate.validator.internal.xml.ConstrainedTypeBuilder;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.XmlParserHelper;
import org.hibernate.validator.internal.xml.binding.BeanType;
import org.hibernate.validator.internal.xml.binding.ConstraintDefinitionType;
import org.hibernate.validator.internal.xml.binding.ConstraintMappingsType;
import org.hibernate.validator.internal.xml.binding.ValidatedByType;
import org.xml.sax.SAXException;

public class MappingXmlParser {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final Set<Class<?>> processedClasses = CollectionHelper.newHashSet();
    private final ConstraintHelper constraintHelper;
    private final TypeResolutionHelper typeResolutionHelper;
    private final ValueExtractorManager valueExtractorManager;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;
    private final Map<Class<?>, List<Class<?>>> defaultSequences;
    private final Map<Class<?>, Set<ConstrainedElement>> constrainedElements;
    private final XmlParserHelper xmlParserHelper;
    private final ClassLoadingHelper classLoadingHelper;
    private static final Map<String, String> SCHEMAS_BY_VERSION = Collections.unmodifiableMap(MappingXmlParser.getSchemasByVersion());

    private static Map<String, String> getSchemasByVersion() {
        HashMap<String, String> schemasByVersion = new HashMap<String, String>();
        schemasByVersion.put("1.0", "META-INF/validation-mapping-1.0.xsd");
        schemasByVersion.put("1.1", "META-INF/validation-mapping-1.1.xsd");
        schemasByVersion.put("2.0", "META-INF/validation-mapping-2.0.xsd");
        return schemasByVersion;
    }

    public MappingXmlParser(ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager, ClassLoader externalClassLoader) {
        this.constraintHelper = constraintHelper;
        this.typeResolutionHelper = typeResolutionHelper;
        this.valueExtractorManager = valueExtractorManager;
        this.annotationProcessingOptions = new AnnotationProcessingOptionsImpl();
        this.defaultSequences = CollectionHelper.newHashMap();
        this.constrainedElements = CollectionHelper.newHashMap();
        this.xmlParserHelper = new XmlParserHelper();
        this.classLoadingHelper = new ClassLoadingHelper(externalClassLoader);
    }

    public final void parse(Set<InputStream> mappingStreams) {
        try {
            JAXBContext jc = this.run(NewJaxbContext.action(ConstraintMappingsType.class));
            MetaConstraintBuilder metaConstraintBuilder = new MetaConstraintBuilder(this.classLoadingHelper, this.constraintHelper, this.typeResolutionHelper, this.valueExtractorManager);
            GroupConversionBuilder groupConversionBuilder = new GroupConversionBuilder(this.classLoadingHelper);
            ConstrainedTypeBuilder constrainedTypeBuilder = new ConstrainedTypeBuilder(this.classLoadingHelper, metaConstraintBuilder, this.annotationProcessingOptions, this.defaultSequences);
            ConstrainedFieldBuilder constrainedFieldBuilder = new ConstrainedFieldBuilder(metaConstraintBuilder, groupConversionBuilder, this.annotationProcessingOptions);
            ConstrainedExecutableBuilder constrainedExecutableBuilder = new ConstrainedExecutableBuilder(this.classLoadingHelper, metaConstraintBuilder, groupConversionBuilder, this.annotationProcessingOptions);
            ConstrainedGetterBuilder constrainedGetterBuilder = new ConstrainedGetterBuilder(metaConstraintBuilder, groupConversionBuilder, this.annotationProcessingOptions);
            HashSet<String> alreadyProcessedConstraintDefinitions = CollectionHelper.newHashSet();
            for (InputStream in : mappingStreams) {
                ConstraintMappingsType mapping = this.unmarshal(jc, in);
                String defaultPackage = mapping.getDefaultPackage();
                this.parseConstraintDefinitions(mapping.getConstraintDefinition(), defaultPackage, alreadyProcessedConstraintDefinitions);
                for (BeanType bean : mapping.getBean()) {
                    this.processBeanType(constrainedTypeBuilder, constrainedFieldBuilder, constrainedExecutableBuilder, constrainedGetterBuilder, defaultPackage, bean);
                }
                in.reset();
            }
        }
        catch (IOException | JAXBException | XMLStreamException | SAXException e) {
            throw LOG.getErrorParsingMappingFileException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstraintMappingsType unmarshal(JAXBContext jc, InputStream in) throws JAXBException, XMLStreamException, IOException, SAXException {
        ClassLoader previousTccl = MappingXmlParser.run(GetClassLoader.fromContext());
        try {
            MappingXmlParser.run(SetContextClassLoader.action(MappingXmlParser.class.getClassLoader()));
            in.mark(Integer.MAX_VALUE);
            XMLEventReader xmlEventReader = this.xmlParserHelper.createXmlEventReader("constraint mapping file", new CloseIgnoringInputStream(in));
            String schemaVersion = this.xmlParserHelper.getSchemaVersion("constraint mapping file", xmlEventReader);
            xmlEventReader.close();
            in.reset();
            String schemaResourceName = this.getSchemaResourceName(schemaVersion);
            Schema schema = this.xmlParserHelper.getSchema(schemaResourceName);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new CloseIgnoringInputStream(in)));
            in.reset();
            xmlEventReader = this.xmlParserHelper.createXmlEventReader("constraint mapping file", new CloseIgnoringInputStream(in));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            ConstraintMappingsType mapping = this.getValidationConfig(xmlEventReader, unmarshaller);
            xmlEventReader.close();
            ConstraintMappingsType constraintMappingsType = mapping;
            return constraintMappingsType;
        }
        finally {
            MappingXmlParser.run(SetContextClassLoader.action(previousTccl));
        }
    }

    public final Set<Class<?>> getXmlConfiguredClasses() {
        return this.processedClasses;
    }

    public final AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }

    public final Set<ConstrainedElement> getConstrainedElementsForClass(Class<?> beanClass) {
        if (this.constrainedElements.containsKey(beanClass)) {
            return this.constrainedElements.get(beanClass);
        }
        return Collections.emptySet();
    }

    public final List<Class<?>> getDefaultSequenceForClass(Class<?> beanClass) {
        return this.defaultSequences.get(beanClass);
    }

    private void processBeanType(ConstrainedTypeBuilder constrainedTypeBuilder, ConstrainedFieldBuilder constrainedFieldBuilder, ConstrainedExecutableBuilder constrainedExecutableBuilder, ConstrainedGetterBuilder constrainedGetterBuilder, String defaultPackage, BeanType bean) {
        Class<?> beanClass = this.classLoadingHelper.loadClass(bean.getClazz(), defaultPackage);
        this.checkClassHasNotBeenProcessed(this.processedClasses, beanClass);
        this.annotationProcessingOptions.ignoreAnnotationConstraintForClass(beanClass, bean.getIgnoreAnnotations());
        ConstrainedType constrainedType = constrainedTypeBuilder.buildConstrainedType(bean.getClassType(), beanClass, defaultPackage);
        if (constrainedType != null) {
            this.addConstrainedElement(beanClass, constrainedType);
        }
        Set<ConstrainedField> constrainedFields = constrainedFieldBuilder.buildConstrainedFields(bean.getField(), beanClass, defaultPackage);
        this.addConstrainedElements(beanClass, constrainedFields);
        Set<ConstrainedExecutable> constrainedGetters = constrainedGetterBuilder.buildConstrainedGetters(bean.getGetter(), beanClass, defaultPackage);
        this.addConstrainedElements(beanClass, constrainedGetters);
        Set<ConstrainedExecutable> constrainedConstructors = constrainedExecutableBuilder.buildConstructorConstrainedExecutable(bean.getConstructor(), beanClass, defaultPackage);
        this.addConstrainedElements(beanClass, constrainedConstructors);
        Set<ConstrainedExecutable> constrainedMethods = constrainedExecutableBuilder.buildMethodConstrainedExecutable(bean.getMethod(), beanClass, defaultPackage);
        this.addConstrainedElements(beanClass, constrainedMethods);
        this.processedClasses.add(beanClass);
    }

    private void parseConstraintDefinitions(List<ConstraintDefinitionType> constraintDefinitionList, String defaultPackage, Set<String> alreadyProcessedConstraintDefinitions) {
        for (ConstraintDefinitionType constraintDefinition : constraintDefinitionList) {
            String annotationClassName = constraintDefinition.getAnnotation();
            if (alreadyProcessedConstraintDefinitions.contains(annotationClassName)) {
                throw LOG.getOverridingConstraintDefinitionsInMultipleMappingFilesException(annotationClassName);
            }
            alreadyProcessedConstraintDefinitions.add(annotationClassName);
            Class<?> clazz = this.classLoadingHelper.loadClass(annotationClassName, defaultPackage);
            if (!clazz.isAnnotation()) {
                throw LOG.getIsNotAnAnnotationException(clazz);
            }
            Class<?> annotationClass = clazz;
            this.addValidatorDefinitions(annotationClass, defaultPackage, constraintDefinition.getValidatedBy());
        }
    }

    private <A extends Annotation> void addValidatorDefinitions(Class<A> annotationClass, String defaultPackage, ValidatedByType validatedByType) {
        ArrayList constraintValidatorDescriptors = new ArrayList(validatedByType.getValue().size());
        for (String validatorClassName : validatedByType.getValue()) {
            Class<?> validatorClass = this.classLoadingHelper.loadClass(validatorClassName, defaultPackage);
            if (!ConstraintValidator.class.isAssignableFrom(validatorClass)) {
                throw LOG.getIsNotAConstraintValidatorClassException(validatorClass);
            }
            constraintValidatorDescriptors.add(ConstraintValidatorDescriptor.forClass(validatorClass));
        }
        this.constraintHelper.putValidatorDescriptors(annotationClass, constraintValidatorDescriptors, Boolean.TRUE.equals(validatedByType.getIncludeExistingValidators()));
    }

    private void checkClassHasNotBeenProcessed(Set<Class<?>> processedClasses, Class<?> beanClass) {
        if (processedClasses.contains(beanClass)) {
            throw LOG.getBeanClassHasAlreadyBeConfiguredInXmlException(beanClass);
        }
    }

    private void addConstrainedElement(Class<?> beanClass, ConstrainedElement constrainedElement) {
        if (this.constrainedElements.containsKey(beanClass)) {
            this.constrainedElements.get(beanClass).add(constrainedElement);
        } else {
            HashSet tmpList = CollectionHelper.newHashSet();
            tmpList.add(constrainedElement);
            this.constrainedElements.put(beanClass, tmpList);
        }
    }

    private void addConstrainedElements(Class<?> beanClass, Set<? extends ConstrainedElement> newConstrainedElements) {
        if (this.constrainedElements.containsKey(beanClass)) {
            Set<ConstrainedElement> existingConstrainedElements = this.constrainedElements.get(beanClass);
            for (ConstrainedElement constrainedElement : newConstrainedElements) {
                if (!existingConstrainedElements.contains(constrainedElement)) continue;
                throw LOG.getConstrainedElementConfiguredMultipleTimesException(constrainedElement.toString());
            }
            existingConstrainedElements.addAll(newConstrainedElements);
        } else {
            HashSet tmpSet = CollectionHelper.newHashSet();
            tmpSet.addAll(newConstrainedElements);
            this.constrainedElements.put(beanClass, tmpSet);
        }
    }

    private ConstraintMappingsType getValidationConfig(XMLEventReader xmlEventReader, Unmarshaller unmarshaller) {
        ConstraintMappingsType constraintMappings;
        try {
            JAXBElement root = (JAXBElement)((Object)this.run(Unmarshal.action(unmarshaller, xmlEventReader, ConstraintMappingsType.class)));
            constraintMappings = (ConstraintMappingsType)root.getValue();
        }
        catch (Exception e) {
            throw LOG.getErrorParsingMappingFileException(e);
        }
        return constraintMappings;
    }

    private String getSchemaResourceName(String schemaVersion) {
        String schemaResource = SCHEMAS_BY_VERSION.get(schemaVersion);
        if (schemaResource == null) {
            throw LOG.getUnsupportedSchemaVersionException("constraint mapping file", schemaVersion);
        }
        return schemaResource;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private <T> T run(PrivilegedExceptionAction<T> action) throws JAXBException {
        try {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Exception e) {
            throw LOG.getErrorParsingMappingFileException(e);
        }
    }
}

