/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBElement;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorManager;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.core.MetaConstraints;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.annotation.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotation.ConstraintAnnotationDescriptor;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.binding.AnnotationType;
import org.hibernate.validator.internal.xml.binding.ConstraintType;
import org.hibernate.validator.internal.xml.binding.ElementType;
import org.hibernate.validator.internal.xml.binding.GroupsType;
import org.hibernate.validator.internal.xml.binding.PayloadType;

class MetaConstraintBuilder {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private static final Pattern IS_ONLY_WHITESPACE = Pattern.compile("\\s*");
    private static final Class[] EMPTY_CLASSES_ARRAY = new Class[0];
    private final ClassLoadingHelper classLoadingHelper;
    private final ConstraintHelper constraintHelper;
    private final TypeResolutionHelper typeResolutionHelper;
    private final ValueExtractorManager valueExtractorManager;

    MetaConstraintBuilder(ClassLoadingHelper classLoadingHelper, ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager) {
        this.classLoadingHelper = classLoadingHelper;
        this.constraintHelper = constraintHelper;
        this.typeResolutionHelper = typeResolutionHelper;
        this.valueExtractorManager = valueExtractorManager;
    }

    <A extends Annotation> MetaConstraint<A> buildMetaConstraint(ConstraintLocation constraintLocation, ConstraintType constraint, java.lang.annotation.ElementType type, String defaultPackage, ConstraintDescriptorImpl.ConstraintType constraintType) {
        AnnotationDescriptor annotationDescriptor;
        Class<?> annotationClass;
        try {
            annotationClass = this.classLoadingHelper.loadClass(constraint.getAnnotation(), defaultPackage);
        }
        catch (ValidationException e) {
            throw LOG.getUnableToLoadConstraintAnnotationClassException(constraint.getAnnotation(), e);
        }
        ConstraintAnnotationDescriptor.Builder annotationDescriptorBuilder = new ConstraintAnnotationDescriptor.Builder(annotationClass);
        if (constraint.getMessage() != null) {
            annotationDescriptorBuilder.setMessage(constraint.getMessage());
        }
        annotationDescriptorBuilder.setGroups(this.getGroups(constraint.getGroups(), defaultPackage)).setPayload(this.getPayload(constraint.getPayload(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            MetaConstraintBuilder.checkNameIsValid(name);
            Class<?> returnType = MetaConstraintBuilder.getAnnotationParameterType(annotationClass, name);
            Object elementValue = this.getElementValue(elementType, returnType, defaultPackage);
            annotationDescriptorBuilder.setAttribute(name, elementValue);
        }
        try {
            annotationDescriptor = annotationDescriptorBuilder.build();
        }
        catch (RuntimeException e) {
            throw LOG.getUnableToCreateAnnotationForConfiguredConstraintException(e);
        }
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(this.constraintHelper, constraintLocation.getMember(), annotationDescriptor, type, constraintType);
        return MetaConstraints.create(this.typeResolutionHelper, this.valueExtractorManager, constraintDescriptor, constraintLocation);
    }

    private <A extends Annotation> Annotation buildAnnotation(AnnotationType annotationType, Class<A> returnType, String defaultPackage) {
        AnnotationDescriptor.Builder<Class<A>> annotationDescriptorBuilder = new AnnotationDescriptor.Builder<Class<A>>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> parameterType = MetaConstraintBuilder.getAnnotationParameterType(returnType, name);
            Object elementValue = this.getElementValue(elementType, parameterType, defaultPackage);
            annotationDescriptorBuilder.setAttribute(name, elementValue);
        }
        return annotationDescriptorBuilder.build().getAnnotation();
    }

    private static void checkNameIsValid(String name) {
        if ("message".equals(name) || "groups".equals(name)) {
            throw LOG.getReservedParameterNamesException("message", "groups", "payload");
        }
    }

    private static <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        Method m3 = MetaConstraintBuilder.run(GetMethod.action(annotationClass, name));
        if (m3 == null) {
            throw LOG.getAnnotationDoesNotContainAParameterException(annotationClass, name);
        }
        return m3.getReturnType();
    }

    private Object getElementValue(ElementType elementType, Class<?> returnType, String defaultPackage) {
        MetaConstraintBuilder.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() == 0) {
                if (returnType == String.class) {
                    return "";
                }
                throw LOG.getEmptyElementOnlySupportedWhenCharSequenceIsExpectedExpection();
            }
            if (elementType.getContent().size() > 1) {
                throw LOG.getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException();
            }
            return this.getSingleValue(elementType.getContent().get(0), returnType, defaultPackage);
        }
        ArrayList<Object> values = CollectionHelper.newArrayList();
        for (Serializable s2 : elementType.getContent()) {
            values.add(this.getSingleValue(s2, returnType.getComponentType(), defaultPackage));
        }
        return values.toArray((Object[])Array.newInstance(returnType.getComponentType(), values.size()));
    }

    private static void removeEmptyContentElements(ElementType elementType) {
        Iterator<Serializable> contentIterator = elementType.getContent().iterator();
        while (contentIterator.hasNext()) {
            Serializable content = contentIterator.next();
            if (!(content instanceof String) || !IS_ONLY_WHITESPACE.matcher((String)((Object)content)).matches()) continue;
            contentIterator.remove();
        }
    }

    private Object getSingleValue(Serializable serializable, Class<?> returnType, String defaultPackage) {
        Object returnValue;
        if (serializable instanceof String) {
            String value = (String)((Object)serializable);
            returnValue = this.convertStringToReturnType(returnType, value, defaultPackage);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(String.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            String value = (String)elem.getValue();
            returnValue = this.convertStringToReturnType(returnType, value, defaultPackage);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(AnnotationType.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            AnnotationType annotationType = (AnnotationType)elem.getValue();
            try {
                Class<?> annotationClass = returnType;
                returnValue = this.buildAnnotation(annotationType, annotationClass, defaultPackage);
            }
            catch (ClassCastException e) {
                throw LOG.getUnexpectedParameterValueException(e);
            }
        } else {
            throw LOG.getUnexpectedParameterValueException();
        }
        return returnValue;
    }

    private Object convertStringToReturnType(Class<?> returnType, String value, String defaultPackage) {
        Class<?> returnValue;
        if (returnType == Byte.TYPE) {
            try {
                returnValue = Byte.parseByte(value);
            }
            catch (NumberFormatException e) {
                throw LOG.getInvalidNumberFormatException("byte", e);
            }
        }
        if (returnType == Short.TYPE) {
            try {
                returnValue = Short.parseShort(value);
            }
            catch (NumberFormatException e) {
                throw LOG.getInvalidNumberFormatException("short", e);
            }
        }
        if (returnType == Integer.TYPE) {
            try {
                returnValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw LOG.getInvalidNumberFormatException("int", e);
            }
        }
        if (returnType == Long.TYPE) {
            try {
                returnValue = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw LOG.getInvalidNumberFormatException("long", e);
            }
        }
        if (returnType == Float.TYPE) {
            try {
                returnValue = Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw LOG.getInvalidNumberFormatException("float", e);
            }
        }
        if (returnType == Double.TYPE) {
            try {
                returnValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw LOG.getInvalidNumberFormatException("double", e);
            }
        }
        if (returnType == Boolean.TYPE) {
            returnValue = Boolean.parseBoolean(value);
        } else if (returnType == Character.TYPE) {
            if (value.length() != 1) {
                throw LOG.getInvalidCharValueException(value);
            }
            returnValue = Character.valueOf(value.charAt(0));
        } else if (returnType == String.class) {
            returnValue = value;
        } else if (returnType == Class.class) {
            returnValue = this.classLoadingHelper.loadClass(value, defaultPackage);
        } else {
            try {
                Class<?> enumClass = returnType;
                returnValue = Enum.valueOf(enumClass, value);
            }
            catch (ClassCastException e) {
                throw LOG.getInvalidReturnTypeException(returnType, e);
            }
        }
        return returnValue;
    }

    private Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return EMPTY_CLASSES_ARRAY;
        }
        ArrayList<Class> groupList = CollectionHelper.newArrayList();
        for (String groupClass : groupsType.getValue()) {
            groupList.add(this.classLoadingHelper.loadClass(groupClass, defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private Class<? extends Payload>[] getPayload(PayloadType payloadType, String defaultPackage) {
        if (payloadType == null) {
            return EMPTY_CLASSES_ARRAY;
        }
        ArrayList<Class> payloadList = CollectionHelper.newArrayList();
        for (String groupClass : payloadType.getValue()) {
            Class<?> payload = this.classLoadingHelper.loadClass(groupClass, defaultPackage);
            if (!Payload.class.isAssignableFrom(payload)) {
                throw LOG.getWrongPayloadClassException(payload);
            }
            payloadList.add(payload);
        }
        return payloadList.toArray(new Class[payloadList.size()]);
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

