/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.ObjectUtils;
import org.jfree.chart.util.PublicCloneable;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XIntervalDataItem;
import org.jfree.data.xy.XIntervalSeries;

public class XIntervalSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
PublicCloneable,
Serializable {
    private List data = new ArrayList();

    public void addSeries(XIntervalSeries series) {
        Args.nullNotPermitted(series, "series");
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public XIntervalSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XIntervalSeries)this.data.get(series);
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    @Override
    public Number getX(int series, int item) {
        XIntervalSeries s2 = (XIntervalSeries)this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s2.getDataItem(item);
        return di.getX();
    }

    @Override
    public double getStartXValue(int series, int item) {
        XIntervalSeries s2 = (XIntervalSeries)this.data.get(series);
        return s2.getXLowValue(item);
    }

    @Override
    public double getEndXValue(int series, int item) {
        XIntervalSeries s2 = (XIntervalSeries)this.data.get(series);
        return s2.getXHighValue(item);
    }

    @Override
    public double getYValue(int series, int item) {
        XIntervalSeries s2 = (XIntervalSeries)this.data.get(series);
        return s2.getYValue(item);
    }

    @Override
    public Number getY(int series, int item) {
        XIntervalSeries s2 = (XIntervalSeries)this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s2.getDataItem(item);
        return new Double(di.getYValue());
    }

    @Override
    public Number getStartX(int series, int item) {
        XIntervalSeries s2 = (XIntervalSeries)this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s2.getDataItem(item);
        return new Double(di.getXLowValue());
    }

    @Override
    public Number getEndX(int series, int item) {
        XIntervalSeries s2 = (XIntervalSeries)this.data.get(series);
        XIntervalDataItem di = (XIntervalDataItem)s2.getDataItem(item);
        return new Double(di.getXHighValue());
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public void removeSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XIntervalSeries ts = (XIntervalSeries)this.data.get(series);
        ts.removeChangeListener(this);
        this.data.remove(series);
        this.fireDatasetChanged();
    }

    public void removeSeries(XIntervalSeries series) {
        Args.nullNotPermitted(series, "series");
        if (this.data.contains(series)) {
            series.removeChangeListener(this);
            this.data.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            XIntervalSeries series = (XIntervalSeries)this.data.get(i);
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XIntervalSeriesCollection)) {
            return false;
        }
        XIntervalSeriesCollection that = (XIntervalSeriesCollection)obj;
        return ObjectUtils.equal(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XIntervalSeriesCollection clone = (XIntervalSeriesCollection)super.clone();
        clone.data = (List)ObjectUtils.deepClone(this.data);
        return clone;
    }
}

