/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.locator;

import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jvnet.jaxb2_commons.locator.DefaultItemObjectLocator;
import org.jvnet.jaxb2_commons.locator.DefaultPropertyObjectLocator;
import org.jvnet.jaxb2_commons.locator.ItemObjectLocator;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.PropertyObjectLocator;
import org.w3c.dom.Node;

public abstract class AbstractObjectLocator
implements ObjectLocator {
    protected final ObjectLocator parentLocator;
    protected final Object object;

    protected AbstractObjectLocator(ObjectLocator parentLocator, Object object) {
        this.object = object;
        this.parentLocator = parentLocator;
    }

    @Override
    public ObjectLocator getParentLocator() {
        return this.parentLocator;
    }

    @Override
    public ObjectLocator[] getPath() {
        ObjectLocator[] path = new ObjectLocator[this.getAncestorCount(this) + 1];
        this.fillPath(this, path, path.length - 1);
        return path;
    }

    @Override
    public String getPathAsString() {
        String stepAsString = this.getStepAsString();
        ObjectLocator parentLocator = this.getParentLocator();
        return parentLocator == null ? stepAsString : parentLocator.getPathAsString() + stepAsString;
    }

    protected abstract String getStepAsString();

    private void fillPath(ObjectLocator locator, ObjectLocator[] path, int index) {
        path[index] = locator;
        ObjectLocator parent = locator.getParentLocator();
        if (parent != null) {
            this.fillPath(parent, path, index - 1);
        }
    }

    private int getAncestorCount(ObjectLocator locator) {
        ObjectLocator parent = locator.getParentLocator();
        if (parent == null) {
            return 0;
        }
        return 1 + this.getAncestorCount(parent);
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public int getColumnNumber() {
        return 0;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessageCode() {
        return this.getClass().getName();
    }

    protected abstract String getDefaultMessage();

    @Override
    public String getMessage(ResourceBundle bundle2) {
        try {
            String messageTemplate = bundle2.getString(this.getMessageCode());
            return MessageFormat.format(messageTemplate, this.getMessageParameters());
        }
        catch (MissingResourceException mrex) {
            return this.getDefaultMessage();
        }
    }

    @Override
    public String getMessage() {
        return this.getMessage(ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".messages"));
    }

    @Override
    public ItemObjectLocator item(int index, Object value) {
        return new DefaultItemObjectLocator(this, index, value);
    }

    @Override
    public PropertyObjectLocator property(String name, Object value) {
        return new DefaultPropertyObjectLocator(this, name, value);
    }
}

