/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.matsim.analysis.BinEntry;
import org.matsim.core.utils.charts.BarChart;
import org.matsim.core.utils.io.IOUtils;

public class Bins {
    protected double interval;
    protected int numberOfBins;
    protected double maxVal;
    protected String desc;
    protected List<BinEntry> entries = new Vector<BinEntry>();
    protected double[] bins;
    private static final Logger log = Logger.getLogger(Bins.class);

    public Bins(double interval, double maxVal, String desc) {
        this.interval = interval;
        this.maxVal = maxVal;
        this.numberOfBins = (int)Math.ceil(maxVal / interval);
        this.desc = desc;
        this.bins = new double[this.numberOfBins];
    }

    public void addValues(double[] values, double[] weights) {
        for (int index = 0; index < values.length; ++index) {
            this.addVal(values[index], weights[index]);
        }
    }

    public void addVal(double value, double weight) {
        int index = (int)Math.floor(value / this.interval);
        if (value >= this.maxVal) {
            index = this.numberOfBins - 1;
        }
        if (value < 0.0) {
            log.error("Value < 0.0 received");
            index = 0;
        }
        int n = index;
        this.bins[n] = this.bins[n] + weight;
        this.entries.add(new BinEntry(value, weight));
    }

    public void clear() {
        this.entries.clear();
        this.bins = new double[this.numberOfBins];
    }

    public void plotBinnedDistribution(String path, String xLabel, String xUnit) {
        String[] categories = new String[this.numberOfBins];
        for (int i = 0; i < this.numberOfBins; ++i) {
            categories[i] = Integer.toString(i);
        }
        Double[] values = new Double[this.entries.size()];
        Double[] weights = new Double[this.entries.size()];
        for (int index = 0; index < this.entries.size(); ++index) {
            values[index] = this.entries.get(index).getValue();
            weights[index] = this.entries.get(index).getWeight();
        }
        DecimalFormat formatter = new DecimalFormat("0.0000");
        String s2 = xLabel + " " + "[interval = " + formatter.format(this.interval) + xUnit + "]" + "[number of entries = " + this.entries.size() + "]" + "[mean = " + formatter.format(this.weightedMean(values, weights)) + xUnit + "]" + "[median = " + formatter.format(this.median(values)) + xUnit + "]" + "[max = " + formatter.format(this.getMax(values)) + xUnit + "]";
        BarChart chart = new BarChart(this.desc, s2, "#", categories);
        chart.addSeries("Bin size", this.bins);
        chart.saveAsPng(path + this.desc + ".png", 1600, 800);
        try {
            BufferedWriter out = IOUtils.getBufferedWriter(path + this.desc + ".txt");
            out.write("Bin [interval = " + this.interval + " " + xUnit + "]\t" + "#" + "\n");
            for (int j = 0; j < this.bins.length; ++j) {
                out.write(j + "\t" + this.bins[j] + "\n");
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double[] getBins() {
        return this.bins;
    }

    public void setBins(double[] bins) {
        this.bins = bins;
    }

    public double getInterval() {
        return this.interval;
    }

    public void setInterval(double interval) {
        this.interval = interval;
    }

    private double median(Double[] values) {
        Vector<Double> list = new Vector<Double>();
        Collections.addAll(list, values);
        return this.median(list);
    }

    public double median(List<Double> values) {
        if (values.size() == 0) {
            return 0.0;
        }
        Collections.sort(values);
        if (values.size() % 2 != 0) {
            return values.get((values.size() + 1) / 2 - 1);
        }
        double lower = values.get(values.size() / 2 - 1);
        double upper = values.get(values.size() / 2);
        return (lower + upper) / 2.0;
    }

    public double mean(List<Double> values) {
        double sum = 0.0;
        int cnt = 0;
        if (values.size() == 0) {
            return 0.0;
        }
        for (Double value : values) {
            sum += value.doubleValue();
            ++cnt;
        }
        return sum / (double)cnt;
    }

    public double weightedMean(List<Double> values, List<Double> weights) {
        return this.weightedMean(values.toArray(new Double[values.size()]), weights.toArray(new Double[weights.size()]));
    }

    public double weightedMean(Double[] values, Double[] weights) {
        double sumValues = 0.0;
        double sumWeights = 0.0;
        if (values.length == 0) {
            return 0.0;
        }
        if (values.length != weights.length) {
            log.info("size of weights and values not identical");
            return -1.0;
        }
        for (int index = 0; index < values.length; ++index) {
            sumValues += values[index] * weights[index];
            sumWeights += weights[index].doubleValue();
        }
        return sumValues / sumWeights;
    }

    public double getMax(List<Double> values) {
        return this.getMax(values.toArray(new Double[values.size()]));
    }

    public double getMax(Double[] values) {
        double maxVal = Double.MIN_VALUE;
        for (Double v : values) {
            if (!(v > maxVal)) continue;
            maxVal = v;
        }
        return maxVal;
    }
}

