/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.algorithms.AbstractPersonAlgorithm;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;

public class CalcAverageTripLength
extends AbstractPersonAlgorithm
implements PlanAlgorithm {
    private double sumLength = 0.0;
    private int cntTrips = 0;
    private final Network network;

    public CalcAverageTripLength(Network network) {
        this.network = network;
    }

    @Override
    public void run(Person person) {
        this.run((Plan)person.getSelectedPlan());
    }

    @Override
    public void run(Plan plan) {
        for (PlanElement pe : plan.getPlanElements()) {
            Leg leg;
            Route route;
            if (!(pe instanceof Leg) || (route = (leg = (Leg)pe).getRoute()) == null) continue;
            double dist = RouteUtils.calcDistanceExcludingStartEndLink((NetworkRoute)route, this.network);
            if (route.getEndLinkId() != null && route.getStartLinkId() != route.getEndLinkId()) {
                dist += this.network.getLinks().get(route.getEndLinkId()).getLength();
            }
            this.sumLength += dist;
            ++this.cntTrips;
        }
    }

    public double getAverageTripLength() {
        if (this.cntTrips == 0) {
            return 0.0;
        }
        return this.sumLength / (double)this.cntTrips;
    }
}

