/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.handler.ActivityEndEventHandler;
import org.matsim.api.core.v01.events.handler.ActivityStartEventHandler;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.misc.Time;

public class CalcLegTimes
implements PersonDepartureEventHandler,
PersonArrivalEventHandler,
ActivityEndEventHandler,
ActivityStartEventHandler {
    private static final Logger log = Logger.getLogger(CalcLegTimes.class);
    private static final int SLOT_SIZE = 300;
    private static final int MAXINDEX = 12;
    private final Map<Id<Person>, Double> agentDepartures = new HashMap<Id<Person>, Double>();
    private final Map<Id<Person>, Double> agentArrivals = new HashMap<Id<Person>, Double>();
    private final Map<String, int[]> legStats = new TreeMap<String, int[]>();
    private final Map<Id<Person>, String> previousActivityTypes = new HashMap<Id<Person>, String>();
    private double sumTripDurations = 0.0;
    private int sumTrips = 0;

    @Inject
    CalcLegTimes(EventsManager eventsManager) {
        eventsManager.addHandler(this);
    }

    public CalcLegTimes() {
    }

    @Override
    public void handleEvent(ActivityEndEvent event) {
        this.previousActivityTypes.put(event.getPersonId(), event.getActType());
    }

    @Override
    public void handleEvent(PersonDepartureEvent event) {
        this.agentDepartures.put(event.getPersonId(), event.getTime());
    }

    @Override
    public void handleEvent(PersonArrivalEvent event) {
        this.agentArrivals.put(event.getPersonId(), event.getTime());
    }

    @Override
    public void handleEvent(ActivityStartEvent event) {
        Double depTime = this.agentDepartures.remove(event.getPersonId());
        Double arrTime = this.agentArrivals.remove(event.getPersonId());
        if (depTime != null) {
            double travTime = arrTime - depTime;
            String fromActType = this.previousActivityTypes.remove(event.getPersonId());
            String toActType = event.getActType();
            String legType = fromActType + "---" + toActType;
            int[] stats = this.legStats.get(legType);
            if (stats == null) {
                stats = new int[13];
                for (int i = 0; i <= 12; ++i) {
                    stats[i] = 0;
                }
                this.legStats.put(legType, stats);
            }
            int n = CalcLegTimes.getTimeslotIndex(travTime);
            stats[n] = stats[n] + 1;
            this.sumTripDurations += travTime;
            ++this.sumTrips;
        }
    }

    @Override
    public void reset(int iteration) {
        this.previousActivityTypes.clear();
        this.agentDepartures.clear();
        this.legStats.clear();
        this.sumTripDurations = 0.0;
        this.sumTrips = 0;
    }

    public Map<String, int[]> getLegStats() {
        return this.legStats;
    }

    public static int getTimeslotIndex(double time_s) {
        int idx = (int)(time_s / 300.0);
        if (idx > 12) {
            idx = 12;
        }
        return idx;
    }

    public double getAverageTripDuration() {
        return this.sumTripDurations / (double)this.sumTrips;
    }

    public void writeStats(String filename) {
        try (BufferedWriter legStatsFile = IOUtils.getBufferedWriter(filename);){
            this.writeStats(legStatsFile);
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    public void writeStats(Writer out) throws UncheckedIOException {
        try {
            boolean first = true;
            for (Map.Entry<String, int[]> entry : this.legStats.entrySet()) {
                String key = entry.getKey();
                int[] counts = entry.getValue();
                if (first) {
                    first = false;
                    out.write("pattern");
                    for (int i = 0; i < counts.length; ++i) {
                        out.write("\t" + i * 300 / 60 + "+");
                    }
                    out.write("\n");
                }
                out.write(key);
                for (int count : counts) {
                    out.write("\t" + count);
                }
                out.write("\n");
            }
            out.write("\n");
            if (this.sumTrips == 0) {
                out.write("average trip duration: no trips!");
            } else {
                out.write("average trip duration: " + this.sumTripDurations / (double)this.sumTrips + " seconds = " + Time.writeTime((int)(this.sumTripDurations / (double)this.sumTrips)));
            }
            out.write("\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }
}

