/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.analysis.VolumesAnalyzer;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.misc.StringUtils;

public class CalcLinkStats {
    private static final Logger log = Logger.getLogger(CalcLinkStats.class);
    private double volScaleFactor = 1.0;
    private int count = 0;
    private final Map<Id<Link>, LinkData> linkData;
    private final int nofHours;
    private final Network network;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int SUM = 2;
    private static final int NOF_STATS = 3;

    @Inject
    public CalcLinkStats(Network network) {
        this.network = network;
        this.linkData = new TreeMap<Id<Link>, LinkData>();
        this.nofHours = 24;
        this.reset();
    }

    public CalcLinkStats(Network network, double vol_scale_factor) {
        this(network);
        this.volScaleFactor = vol_scale_factor;
    }

    public void addData(VolumesAnalyzer analyzer, TravelTime ttimes) {
        ++this.count;
        for (Id<Link> linkId : this.linkData.keySet()) {
            Link link = this.network.getLinks().get(linkId);
            double[] volumes = analyzer.getVolumesPerHourForLink(linkId);
            LinkData data = this.linkData.get(linkId);
            long sumVolumes = 0L;
            for (int hour = 0; hour < this.nofHours; ++hour) {
                double ttime = ttimes.getLinkTravelTime(link, hour * 3600, null, null);
                sumVolumes = (long)((double)sumVolumes + volumes[hour]);
                if (this.count == 1) {
                    data.volumes[0][hour] = volumes[hour];
                    data.volumes[1][hour] = volumes[hour];
                    data.ttimes[0][hour] = ttime;
                    data.ttimes[1][hour] = ttime;
                } else {
                    if (volumes[hour] < data.volumes[0][hour]) {
                        data.volumes[0][hour] = volumes[hour];
                    }
                    if (volumes[hour] > data.volumes[1][hour]) {
                        data.volumes[1][hour] = volumes[hour];
                    }
                    if (ttime < data.ttimes[0][hour]) {
                        data.ttimes[0][hour] = ttime;
                    }
                    if (ttime > data.ttimes[1][hour]) {
                        data.ttimes[1][hour] = ttime;
                    }
                }
                double[] dArray = data.volumes[2];
                int n = hour;
                dArray[n] = dArray[n] + volumes[hour];
                double[] dArray2 = data.ttimes[2];
                int n2 = hour;
                dArray2[n2] = dArray2[n2] + volumes[hour] * ttime;
            }
            if (this.count == 1) {
                data.volumes[0][this.nofHours] = sumVolumes;
                data.volumes[2][this.nofHours] = sumVolumes;
                data.volumes[1][this.nofHours] = sumVolumes;
                continue;
            }
            if ((double)sumVolumes < data.volumes[0][this.nofHours]) {
                data.volumes[0][this.nofHours] = sumVolumes;
            }
            double[] dArray = data.volumes[2];
            int n = this.nofHours;
            dArray[n] = dArray[n] + (double)sumVolumes;
            if (!((double)sumVolumes > data.volumes[1][this.nofHours])) continue;
            data.volumes[1][this.nofHours] = sumVolumes;
        }
    }

    public void reset() {
        this.linkData.clear();
        this.count = 0;
        log.info(" resetting `count' to zero.  This info is here since we want to check when this is happening during normal simulation runs.  kai, jan'11");
        for (Link link : this.network.getLinks().values()) {
            LinkData data = new LinkData(new double[3][this.nofHours + 1], new double[3][this.nofHours]);
            this.linkData.put(link.getId(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String filename) {
        BufferedWriter out = null;
        try {
            int i;
            out = IOUtils.getBufferedWriter(filename);
            out.write("LINK\tORIG_ID\tFROM\tTO\tLENGTH\tFREESPEED\tCAPACITY");
            for (i = 0; i < this.nofHours; ++i) {
                out.write("\tHRS" + i + "-" + (i + 1) + "min");
                out.write("\tHRS" + i + "-" + (i + 1) + "avg");
                out.write("\tHRS" + i + "-" + (i + 1) + "max");
            }
            out.write("\tHRS0-" + this.nofHours + "min");
            out.write("\tHRS0-" + this.nofHours + "avg");
            out.write("\tHRS0-" + this.nofHours + "max");
            for (i = 0; i < this.nofHours; ++i) {
                out.write("\tTRAVELTIME" + i + "-" + (i + 1) + "min");
                out.write("\tTRAVELTIME" + i + "-" + (i + 1) + "avg");
                out.write("\tTRAVELTIME" + i + "-" + (i + 1) + "max");
            }
            out.write("\n");
            for (Map.Entry<Id<Link>, LinkData> entry : this.linkData.entrySet()) {
                int i2;
                Id<Link> linkId = entry.getKey();
                LinkData data = entry.getValue();
                Link link = this.network.getLinks().get(linkId);
                out.write(linkId.toString());
                out.write("\t");
                out.write("\t" + link.getFromNode().getId().toString());
                out.write("\t" + link.getToNode().getId().toString());
                out.write("\t" + Double.toString(link.getLength()));
                out.write("\t" + Double.toString(link.getFreespeed()));
                out.write("\t" + Double.toString(link.getCapacity()));
                for (i2 = 0; i2 < this.nofHours; ++i2) {
                    out.write("\t" + Double.toString(data.volumes[0][i2]));
                    out.write("\t" + Double.toString(data.volumes[2][i2] / (double)this.count));
                    out.write("\t" + Double.toString(data.volumes[1][i2]));
                }
                out.write("\t" + Double.toString(data.volumes[0][this.nofHours]));
                out.write("\t" + Double.toString(data.volumes[2][this.nofHours] / (double)this.count));
                out.write("\t" + Double.toString(data.volumes[1][this.nofHours]));
                for (i2 = 0; i2 < this.nofHours; ++i2) {
                    double ttsum;
                    String ttimesMin = Double.toString(data.ttimes[0][i2]);
                    out.write("\t" + ttimesMin);
                    if (data.volumes[2][i2] == 0.0) {
                        ttsum = data.ttimes[2][i2];
                        if (ttsum != 0.0) {
                            out.write("\t" + Double.toString(ttsum));
                        } else {
                            out.write("\t" + ttimesMin);
                        }
                    } else {
                        ttsum = data.ttimes[2][i2];
                        if (ttsum == 0.0) {
                            out.write("\t" + ttimesMin);
                        } else {
                            out.write("\t" + Double.toString(ttsum / data.volumes[2][i2]));
                        }
                    }
                    out.write("\t" + Double.toString(data.ttimes[1][i2]));
                }
                out.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.warn("Could not close output-stream.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(String filename) {
        this.reset();
        BufferedReader reader = null;
        try {
            reader = IOUtils.getBufferedReader(filename);
            String header = reader.readLine();
            if (header == null) {
                return;
            }
            this.count = 1;
            String line = reader.readLine();
            while (line != null) {
                int baseTTimes;
                int i;
                LinkData data;
                Object linkId;
                String[] parts = StringUtils.explode(line, '\t');
                if (parts.length == 154) {
                    linkId = Id.create(parts[0], Link.class);
                    data = this.linkData.get(linkId);
                    if (data == null) {
                        System.err.println("CalcLinkStats.readFile(); unknown link: " + linkId.toString());
                    } else {
                        for (i = 0; i < this.nofHours; ++i) {
                            data.volumes[0][i] = Double.parseDouble(parts[7 + i * 3]);
                            double[] dArray = data.volumes[0];
                            int n = i;
                            dArray[n] = dArray[n] * this.volScaleFactor;
                            data.volumes[2][i] = Double.parseDouble(parts[8 + i * 3]);
                            double[] dArray2 = data.volumes[2];
                            int n2 = i;
                            dArray2[n2] = dArray2[n2] * this.volScaleFactor;
                            data.volumes[1][i] = Double.parseDouble(parts[9 + i * 3]);
                            double[] dArray3 = data.volumes[1];
                            int n3 = i;
                            dArray3[n3] = dArray3[n3] * this.volScaleFactor;
                            baseTTimes = 7 + (this.nofHours + 1) * 3;
                            data.ttimes[0][i] = Double.parseDouble(parts[baseTTimes + i * 3]);
                            data.ttimes[2][i] = data.volumes[2][i] == 0.0 ? Double.parseDouble(parts[baseTTimes + i * 3 + 1]) : Double.parseDouble(parts[baseTTimes + i * 3 + 1]) * data.volumes[2][i];
                            data.ttimes[1][i] = Double.parseDouble(parts[baseTTimes + i * 3 + 2]);
                        }
                        data.volumes[0][this.nofHours] = Double.parseDouble(parts[7 + this.nofHours * 3]);
                        double[] dArray = data.volumes[0];
                        int n = this.nofHours;
                        dArray[n] = dArray[n] * this.volScaleFactor;
                        data.volumes[2][this.nofHours] = Double.parseDouble(parts[8 + this.nofHours * 3]);
                        double[] dArray4 = data.volumes[2];
                        int n4 = this.nofHours;
                        dArray4[n4] = dArray4[n4] * this.volScaleFactor;
                        data.volumes[1][this.nofHours] = Double.parseDouble(parts[9 + this.nofHours * 3]);
                        double[] dArray5 = data.volumes[1];
                        int n5 = this.nofHours;
                        dArray5[n5] = dArray5[n5] * this.volScaleFactor;
                    }
                } else {
                    if (parts.length != 153) {
                        System.err.println("CalcLinkStats.readFile(); line cannot be parsed: " + line + " number of colums is: " + parts.length);
                        break;
                    }
                    linkId = parts[0];
                    data = this.linkData.get(Id.create((String)linkId, Link.class));
                    if (data == null) {
                        System.err.println("CalcLinkStats.readFile(); unknown link: " + (String)linkId);
                    } else {
                        for (i = 0; i < this.nofHours; ++i) {
                            data.volumes[0][i] = Double.parseDouble(parts[6 + i * 3]);
                            double[] dArray = data.volumes[0];
                            int n = i;
                            dArray[n] = dArray[n] * this.volScaleFactor;
                            data.volumes[2][i] = Integer.parseInt(parts[7 + i * 3]);
                            double[] dArray6 = data.volumes[2];
                            int n6 = i;
                            dArray6[n6] = dArray6[n6] * this.volScaleFactor;
                            data.volumes[1][i] = Double.parseDouble(parts[8 + i * 3]);
                            double[] dArray7 = data.volumes[1];
                            int n7 = i;
                            dArray7[n7] = dArray7[n7] * this.volScaleFactor;
                            baseTTimes = 6 + (this.nofHours + 1) * 3;
                            data.ttimes[0][i] = Double.parseDouble(parts[baseTTimes + i * 3]);
                            data.ttimes[2][i] = data.volumes[2][i] == 0.0 ? Double.parseDouble(parts[baseTTimes + i * 3 + 1]) : Double.parseDouble(parts[baseTTimes + i * 3 + 1]) * data.volumes[2][i];
                            data.ttimes[1][i] = Double.parseDouble(parts[baseTTimes + i * 3 + 2]);
                        }
                        data.volumes[0][this.nofHours] = Double.parseDouble(parts[6 + this.nofHours * 3]);
                        double[] dArray = data.volumes[0];
                        int n = this.nofHours;
                        dArray[n] = dArray[n] * this.volScaleFactor;
                        data.volumes[2][this.nofHours] = Double.parseDouble(parts[7 + this.nofHours * 3]);
                        double[] dArray8 = data.volumes[2];
                        int n8 = this.nofHours;
                        dArray8[n8] = dArray8[n8] * this.volScaleFactor;
                        data.volumes[1][this.nofHours] = Double.parseDouble(parts[8 + this.nofHours * 3]);
                        double[] dArray9 = data.volumes[1];
                        int n9 = this.nofHours;
                        dArray9[n9] = dArray9[n9] * this.volScaleFactor;
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn("Could not close input-stream.", e);
                }
            }
        }
    }

    public double[] getAvgLinkVolumes(Id<Link> linkId) {
        LinkData data = this.linkData.get(linkId);
        if (data == null) {
            return new double[0];
        }
        if (this.count == 0) {
            return new double[0];
        }
        double[] volumes = new double[this.nofHours];
        for (int i = 0; i < this.nofHours; ++i) {
            volumes[i] = data.volumes[2][i] / (double)this.count;
        }
        return volumes;
    }

    @Deprecated
    protected double[] getAvgTravelTimes(Id<Link> linkId) {
        LinkData data = this.linkData.get(linkId);
        if (data == null) {
            return new double[0];
        }
        if (this.count == 0) {
            return new double[0];
        }
        double[] ttimesMin = new double[this.nofHours];
        double[] ttimesSum = new double[this.nofHours];
        double[] volumes = new double[this.nofHours];
        double[] avgTTimes = new double[this.nofHours];
        for (int i = 0; i < this.nofHours; ++i) {
            volumes[i] = data.volumes[2][i] / (double)this.count;
            ttimesMin[i] = data.ttimes[0][i] / (double)this.count;
            ttimesSum[i] = data.ttimes[2][i] / (double)this.count;
            avgTTimes[i] = volumes[i] == 0.0 ? ttimesMin[i] : ttimesSum[i] / volumes[i];
        }
        return avgTTimes;
    }

    private static class LinkData {
        public final double[][] volumes;
        public final double[][] ttimes;

        public LinkData(double[][] linksVolumes, double[][] linksTTimes) {
            this.volumes = (double[][])linksVolumes.clone();
            this.ttimes = (double[][])linksTTimes.clone();
        }
    }
}

