/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.matsim.core.utils.charts.StackedBarChart;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.misc.Time;

public final class IterationStopWatch {
    public static final String OPERATION_ITERATION = "iteration";
    public static final String OPERATION_OTHER = "other";
    private Integer iteration = null;
    private final Map<Integer, Map<String, Long>> iterations;
    private final List<String> identifiers;
    private final List<String> operations;
    private Map<String, Long> currentIterationValues = null;
    private int nextIdentifierPosition = 0;
    private int nextOperationPosition = 0;
    private final DateFormat formatter = new SimpleDateFormat("HH:mm:ss");
    private Stack<String> currentMeasuredOperations;
    private Map<String, List<String>> currentIterationChildren;
    private Map<Integer, Map<String, List<String>>> children;

    public IterationStopWatch() {
        this.iterations = new LinkedHashMap<Integer, Map<String, Long>>();
        this.identifiers = new LinkedList<String>();
        this.operations = new LinkedList<String>();
        this.children = new LinkedHashMap<Integer, Map<String, List<String>>>();
    }

    public void reset() {
        this.nextIdentifierPosition = 0;
        this.nextOperationPosition = 0;
        this.iteration = null;
        this.currentIterationValues = null;
        this.iterations.clear();
        this.identifiers.clear();
        this.operations.clear();
        this.currentMeasuredOperations.clear();
        this.currentIterationChildren.clear();
        this.children.clear();
    }

    public void beginIteration(int iteration) {
        this.iteration = iteration;
        if (this.iterations.get(this.iteration) == null) {
            this.currentIterationValues = new HashMap<String, Long>();
            this.iterations.put(this.iteration, this.currentIterationValues);
            this.nextIdentifierPosition = 0;
            this.nextOperationPosition = 0;
            this.currentMeasuredOperations = new Stack();
            this.currentIterationChildren = new HashMap<String, List<String>>();
            this.children.put(this.iteration, this.currentIterationChildren);
        }
        this.beginOperation(OPERATION_ITERATION);
    }

    public void beginOperation(String identifier) {
        if (identifier.equals(OPERATION_OTHER)) {
            throw new RuntimeException("Identifier other is reserved! Please use another one. Aborting!");
        }
        String ident = "BEGIN " + identifier;
        this.ensureIdentifier(ident);
        this.currentIterationValues.put(ident, System.currentTimeMillis());
        this.currentIterationChildren.put(identifier, new ArrayList());
        if (this.currentMeasuredOperations.size() > 0) {
            String parent = this.currentMeasuredOperations.peek();
            this.currentIterationChildren.get(parent).add(identifier);
        }
        this.currentMeasuredOperations.push(identifier);
    }

    public void endOperation(String identifier) {
        String ident = "END " + identifier;
        this.ensureIdentifier(ident);
        this.ensureOperation(identifier);
        this.currentIterationValues.put(ident, System.currentTimeMillis());
        this.currentMeasuredOperations.pop();
    }

    public void endIteration() {
        this.endOperation(OPERATION_ITERATION);
    }

    public void timestamp(String identifier) {
        this.ensureIdentifier(identifier);
        this.currentIterationValues.put(identifier, System.currentTimeMillis());
    }

    public void writeTextFile(String filename) {
        try {
            BufferedWriter writer = IOUtils.getBufferedWriter(filename + ".txt");
            writer.write("Iteration");
            for (String string : this.identifiers) {
                writer.write(9);
                writer.write(string);
            }
            writer.write(9);
            for (String string : this.operations) {
                writer.write(9);
                writer.write(string);
            }
            writer.newLine();
            for (Map.Entry entry : this.iterations.entrySet()) {
                Integer iteration = (Integer)entry.getKey();
                Map data = (Map)entry.getValue();
                writer.write(iteration.toString());
                for (String identifier : this.identifiers) {
                    Long time = (Long)data.get(identifier);
                    writer.write(9);
                    writer.write(this.formatMilliTime(time));
                }
                writer.write(9);
                for (String identifier : this.operations) {
                    Long startTime = (Long)data.get("BEGIN " + identifier);
                    Long endTime = (Long)data.get("END " + identifier);
                    writer.write(9);
                    if (startTime == null || endTime == null) continue;
                    double diff = (double)(endTime - startTime) / 1000.0;
                    writer.write(Time.writeTime(diff));
                }
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeGraphFile(String filename) {
        int iterations = this.iterations.entrySet().size();
        HashMap<String, double[]> arrayMap = new HashMap<String, double[]>();
        for (String string : this.operations) {
            arrayMap.put(string, new double[iterations]);
        }
        int iter = 0;
        for (Map.Entry<Integer, Map<String, Long>> entry : this.iterations.entrySet()) {
            Map<String, Long> data = entry.getValue();
            Map<String, List<String>> childrenMap = this.children.get(entry.getKey());
            for (String string : this.operations) {
                Long startTime = data.get("BEGIN " + string);
                Long endTime = data.get("END " + string);
                if (startTime != null && endTime != null) {
                    double diff = endTime - startTime;
                    for (String child : childrenMap.get(string)) {
                        Long childStartTime = data.get("BEGIN " + child);
                        Long childEndTime = data.get("END " + child);
                        diff -= (double)(childEndTime - childStartTime);
                    }
                    ((double[])arrayMap.get((Object)string))[iter] = diff / 1000.0;
                    continue;
                }
                ((double[])arrayMap.get((Object)string))[iter] = 0.0;
            }
            ++iter;
        }
        String string = "Computation time distribution per iteration";
        String string2 = OPERATION_ITERATION;
        String yAxisLabel = "seconds";
        String[] categories = new String[this.iterations.size()];
        int index = 0;
        for (int iteration : this.iterations.keySet()) {
            categories[index] = String.valueOf(iteration);
            ++index;
        }
        StackedBarChart stackedBarChart = new StackedBarChart(string, string2, yAxisLabel, categories);
        stackedBarChart.addMatsimLogo();
        stackedBarChart.getChart().getCategoryPlot().getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        double[] iterationData = null;
        for (String operation : this.operations) {
            double[] data = (double[])arrayMap.get(operation);
            if (operation.equals(OPERATION_ITERATION)) {
                iterationData = data;
                continue;
            }
            stackedBarChart.addSeries(operation, data);
        }
        if (iterationData != null) {
            double[] otherData = new double[iterations];
            System.arraycopy(iterationData, 0, otherData, 0, iterations);
            stackedBarChart.addSeries(OPERATION_OTHER, otherData);
        }
        stackedBarChart.saveAsPng(filename + ".png", 1024, 768);
    }

    private void ensureIdentifier(String identifier) {
        int pos = this.identifiers.indexOf(identifier);
        if (pos == -1) {
            this.identifiers.add(this.nextIdentifierPosition, identifier);
            ++this.nextIdentifierPosition;
        } else {
            this.nextIdentifierPosition = pos + 1;
        }
    }

    private void ensureOperation(String identifier) {
        int pos = this.operations.indexOf(identifier);
        if (pos == -1) {
            this.operations.add(this.nextOperationPosition, identifier);
            ++this.nextOperationPosition;
        } else {
            this.nextOperationPosition = pos + 1;
        }
    }

    private String formatMilliTime(Long millis) {
        if (millis == null) {
            return "";
        }
        return this.formatter.format(new Date(millis));
    }
}

