/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.misc.Time;

public class LegHistogram
implements PersonDepartureEventHandler,
PersonArrivalEventHandler,
PersonStuckEventHandler {
    private Set<Id<Person>> personIds;
    private int iteration = 0;
    private final int binSize;
    private final int nofBins;
    private final Map<String, DataFrame> data = new TreeMap<String, DataFrame>();

    @Inject
    LegHistogram(Population population, EventsManager eventsManager) {
        this(300);
        this.personIds = population == null ? null : population.getPersons().keySet();
        eventsManager.addHandler(this);
    }

    public LegHistogram(int binSize, int nofBins) {
        this.binSize = binSize;
        this.nofBins = nofBins;
        this.reset(0);
    }

    public LegHistogram(int binSize) {
        this(binSize, 108000 / binSize + 1);
    }

    @Override
    public void handleEvent(PersonDepartureEvent event) {
        int index = this.getBinIndex(event.getTime());
        if ((this.personIds == null || this.personIds.contains(event.getPersonId())) && event.getLegMode() != null) {
            DataFrame dataFrame = this.getDataForMode(event.getLegMode());
            int n = index;
            dataFrame.countsDep[n] = dataFrame.countsDep[n] + 1;
        }
    }

    @Override
    public void handleEvent(PersonArrivalEvent event) {
        int index = this.getBinIndex(event.getTime());
        if ((this.personIds == null || this.personIds.contains(event.getPersonId())) && event.getLegMode() != null) {
            DataFrame dataFrame = this.getDataForMode(event.getLegMode());
            int n = index;
            dataFrame.countsArr[n] = dataFrame.countsArr[n] + 1;
        }
    }

    @Override
    public void handleEvent(PersonStuckEvent event) {
        int index = this.getBinIndex(event.getTime());
        if ((this.personIds == null || this.personIds.contains(event.getPersonId())) && event.getLegMode() != null) {
            DataFrame dataFrame = this.getDataForMode(event.getLegMode());
            int n = index;
            dataFrame.countsStuck[n] = dataFrame.countsStuck[n] + 1;
        }
    }

    @Override
    public void reset(int iter) {
        this.iteration = iter;
        this.data.clear();
    }

    public void write(String filename) {
        try (PrintStream stream = IOUtils.getPrintStream(filename);){
            this.write(stream);
        }
    }

    public void write(PrintStream stream) {
        stream.print("time\ttime\tdepartures_all\tarrivals_all\tstuck_all\ten-route_all");
        for (String legMode : this.data.keySet()) {
            stream.print("\tdepartures_" + legMode + "\tarrivals_" + legMode + "\tstuck_" + legMode + "\ten-route_" + legMode);
        }
        stream.print("\n");
        int allEnRoute = 0;
        int[] modeEnRoute = new int[this.data.size()];
        DataFrame allModesData = this.getAllModesData();
        for (int i = 0; i < allModesData.countsDep.length; ++i) {
            allEnRoute = allEnRoute + allModesData.countsDep[i] - allModesData.countsArr[i] - allModesData.countsStuck[i];
            stream.print(Time.writeTime(i * this.binSize) + "\t" + i * this.binSize);
            stream.print("\t" + allModesData.countsDep[i] + "\t" + allModesData.countsArr[i] + "\t" + allModesData.countsStuck[i] + "\t" + allEnRoute);
            int mode = 0;
            for (DataFrame dataFrame : this.data.values()) {
                modeEnRoute[mode] = modeEnRoute[mode] + dataFrame.countsDep[i] - dataFrame.countsArr[i] - dataFrame.countsStuck[i];
                stream.print("\t" + dataFrame.countsDep[i] + "\t" + dataFrame.countsArr[i] + "\t" + dataFrame.countsStuck[i] + "\t" + modeEnRoute[mode]);
                ++mode;
            }
            stream.print("\n");
        }
    }

    public int[] getDepartures() {
        return this.getAllModesData().countsDep;
    }

    public int[] getArrivals() {
        return this.getAllModesData().countsArr;
    }

    public int[] getStuck() {
        return this.getAllModesData().countsStuck;
    }

    public Set<String> getLegModes() {
        return this.data.keySet();
    }

    public int[] getDepartures(String legMode) {
        DataFrame dataFrame = this.data.get(legMode);
        if (dataFrame == null) {
            return new int[0];
        }
        return (int[])dataFrame.countsDep.clone();
    }

    public int[] getArrivals(String legMode) {
        DataFrame dataFrame = this.data.get(legMode);
        if (dataFrame == null) {
            return new int[0];
        }
        return (int[])dataFrame.countsArr.clone();
    }

    public int[] getStuck(String legMode) {
        DataFrame dataFrame = this.data.get(legMode);
        if (dataFrame == null) {
            return new int[0];
        }
        return (int[])dataFrame.countsStuck.clone();
    }

    int getIteration() {
        return this.iteration;
    }

    DataFrame getAllModesData() {
        DataFrame result = new DataFrame(this.binSize, this.nofBins + 1);
        for (DataFrame byMode : this.data.values()) {
            int i;
            for (i = 0; i < result.countsDep.length; ++i) {
                int n = i;
                result.countsDep[n] = result.countsDep[n] + byMode.countsDep[i];
            }
            for (i = 0; i < result.countsArr.length; ++i) {
                int n = i;
                result.countsArr[n] = result.countsArr[n] + byMode.countsArr[i];
            }
            for (i = 0; i < result.countsStuck.length; ++i) {
                int n = i;
                result.countsStuck[n] = result.countsStuck[n] + byMode.countsStuck[i];
            }
        }
        return result;
    }

    private int getBinIndex(double time) {
        int bin = (int)(time / (double)this.binSize);
        if (bin >= this.nofBins) {
            return this.nofBins;
        }
        return bin;
    }

    DataFrame getDataForMode(String legMode) {
        DataFrame dataFrame = this.data.get(legMode);
        if (dataFrame == null) {
            dataFrame = new DataFrame(this.binSize, this.nofBins + 1);
            this.data.put(legMode, dataFrame);
        }
        return dataFrame;
    }

    static class DataFrame {
        final int[] countsDep;
        final int[] countsArr;
        final int[] countsStuck;
        final int binSize;

        public DataFrame(int binSize, int nofBins) {
            this.countsDep = new int[nofBins];
            this.countsArr = new int[nofBins];
            this.countsStuck = new int[nofBins];
            this.binSize = binSize;
        }
    }
}

