/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.matsim.analysis.LegHistogram;
import org.matsim.core.utils.io.UncheckedIOException;

public class LegHistogramChart {
    static JFreeChart getGraphic(LegHistogram.DataFrame dataFrame, String mode, int iteration) {
        XYSeriesCollection xyData = new XYSeriesCollection();
        XYSeries departuresSerie = new XYSeries((Comparable)((Object)"departures"), false, true);
        XYSeries arrivalsSerie = new XYSeries((Comparable)((Object)"arrivals"), false, true);
        XYSeries onRouteSerie = new XYSeries((Comparable)((Object)"en route"), false, true);
        int onRoute = 0;
        for (int i = 0; i < dataFrame.countsDep.length; ++i) {
            onRoute = onRoute + dataFrame.countsDep[i] - dataFrame.countsArr[i] - dataFrame.countsStuck[i];
            double hour = (double)(i * dataFrame.binSize) / 60.0 / 60.0;
            departuresSerie.add(hour, dataFrame.countsDep[i]);
            arrivalsSerie.add(hour, dataFrame.countsArr[i]);
            onRouteSerie.add(hour, onRoute);
        }
        xyData.addSeries(departuresSerie);
        xyData.addSeries(arrivalsSerie);
        xyData.addSeries(onRouteSerie);
        JFreeChart chart = ChartFactory.createXYStepChart("Leg Histogram, " + mode + ", it." + iteration, "time", "# persons", xyData, PlotOrientation.VERTICAL, true, false, false);
        XYPlot plot = chart.getXYPlot();
        CategoryAxis axis1 = new CategoryAxis("hour");
        axis1.setTickLabelFont(new Font("SansSerif", 0, 7));
        plot.setDomainAxis(new NumberAxis("time"));
        plot.getRenderer().setSeriesStroke(0, new BasicStroke(2.0f));
        plot.getRenderer().setSeriesStroke(1, new BasicStroke(2.0f));
        plot.getRenderer().setSeriesStroke(2, new BasicStroke(2.0f));
        plot.setBackgroundPaint(Color.white);
        plot.setRangeGridlinePaint(Color.gray);
        plot.setDomainGridlinePaint(Color.gray);
        return chart;
    }

    public static void writeGraphic(LegHistogram legHistogram, String filename) {
        try {
            ChartUtils.saveChartAsPNG(new File(filename), LegHistogramChart.getGraphic(legHistogram.getAllModesData(), "all", legHistogram.getIteration()), 1024, 768);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeGraphic(LegHistogram legHistogram, String filename, String legMode) {
        try {
            ChartUtils.saveChartAsPNG(new File(filename), LegHistogramChart.getGraphic(legHistogram.getDataForMode(legMode), legMode, legHistogram.getIteration()), 1024, 768);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

