/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.analysis.LegHistogram;
import org.matsim.analysis.LegHistogramChart;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.IterationStartsEvent;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.IterationStartsListener;

final class LegHistogramListener
implements IterationEndsListener,
IterationStartsListener {
    @Inject
    private LegHistogram histogram;
    @Inject
    private ControlerConfigGroup controlerConfigGroup;
    @Inject
    private OutputDirectoryHierarchy controlerIO;
    private static final Logger log = Logger.getLogger(LegHistogramListener.class);

    LegHistogramListener() {
    }

    @Override
    public void notifyIterationStarts(IterationStartsEvent event) {
        this.histogram.reset(event.getIteration());
    }

    @Override
    public void notifyIterationEnds(IterationEndsEvent event) {
        this.histogram.write(this.controlerIO.getIterationFilename(event.getIteration(), "legHistogram.txt"));
        this.printStats();
        if (this.controlerConfigGroup.isCreateGraphs()) {
            LegHistogramChart.writeGraphic(this.histogram, this.controlerIO.getIterationFilename(event.getIteration(), "legHistogram_all.png"));
            for (String legMode : this.histogram.getLegModes()) {
                LegHistogramChart.writeGraphic(this.histogram, this.controlerIO.getIterationFilename(event.getIteration(), "legHistogram_" + legMode + ".png"), legMode);
            }
        }
    }

    private void printStats() {
        int nofLegs = 0;
        for (int nofDepartures : this.histogram.getDepartures()) {
            nofLegs += nofDepartures;
        }
        log.info("number of legs:\t" + nofLegs + "\t100%");
        Object object = this.histogram.getLegModes().iterator();
        while (object.hasNext()) {
            String legMode = (String)object.next();
            int nofModeLegs = 0;
            for (int nofDepartures : this.histogram.getDepartures(legMode)) {
                nofModeLegs += nofDepartures;
            }
            if (nofModeLegs == 0) continue;
            log.info("number of " + legMode + " legs:\t" + nofModeLegs + "\t" + (double)nofModeLegs * 100.0 / (double)nofLegs + "%");
        }
    }
}

