/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.analysis.CalcLegTimes;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.events.AfterMobsimEvent;
import org.matsim.core.controler.listener.AfterMobsimListener;
import org.matsim.core.utils.misc.Time;

class LegTimesControlerListener
implements AfterMobsimListener {
    private static Logger log = Logger.getLogger(LegTimesControlerListener.class);
    private CalcLegTimes legTimes;
    private OutputDirectoryHierarchy controlerIO;

    @Inject
    LegTimesControlerListener(CalcLegTimes legTimes, OutputDirectoryHierarchy controlerIO) {
        this.legTimes = legTimes;
        this.controlerIO = controlerIO;
    }

    @Override
    public void notifyAfterMobsim(AfterMobsimEvent event) {
        this.legTimes.writeStats(this.controlerIO.getIterationFilename(event.getIteration(), "tripdurations.txt"));
        log.info("[" + event.getIteration() + "] average trip (probably: leg) duration is: " + (int)this.legTimes.getAverageTripDuration() + " seconds = " + Time.writeTime(this.legTimes.getAverageTripDuration(), "HH:mm:ss"));
    }
}

