/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.util.Map;
import javax.inject.Inject;
import org.matsim.analysis.CalcLinkStats;
import org.matsim.analysis.VolumesAnalyzer;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.LinkStatsConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.IterationStartsEvent;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.IterationStartsListener;
import org.matsim.core.router.util.TravelTime;

final class LinkStatsControlerListener
implements IterationEndsListener,
IterationStartsListener {
    @Inject
    private LinkStatsConfigGroup linkStatsConfigGroup;
    @Inject
    private ControlerConfigGroup controlerConfigGroup;
    @Inject
    private CalcLinkStats linkStats;
    @Inject
    private VolumesAnalyzer volumes;
    @Inject
    private OutputDirectoryHierarchy controlerIO;
    @Inject
    private Map<String, TravelTime> travelTime;
    private int iterationsUsed = 0;
    private boolean doReset = false;

    LinkStatsControlerListener() {
    }

    @Override
    public void notifyIterationEnds(IterationEndsEvent event) {
        int iteration = event.getIteration();
        if (this.useVolumesOfIteration(iteration, this.controlerConfigGroup.getFirstIteration())) {
            ++this.iterationsUsed;
            this.linkStats.addData(this.volumes, this.travelTime.get("car"));
        }
        if (this.createLinkStatsInIteration(iteration)) {
            this.linkStats.writeFile(this.controlerIO.getIterationFilename(iteration, "linkstats.txt.gz"));
            this.doReset = true;
        }
    }

    @Override
    public void notifyIterationStarts(IterationStartsEvent event) {
        if (this.doReset) {
            this.linkStats.reset();
            this.doReset = false;
        }
    }

    boolean useVolumesOfIteration(int iteration, int firstIteration) {
        if (this.linkStatsConfigGroup.getWriteLinkStatsInterval() < 1) {
            return false;
        }
        int iterationMod = iteration % this.linkStatsConfigGroup.getWriteLinkStatsInterval();
        int effectiveIteration = iteration - firstIteration;
        int averaging = Math.min(this.linkStatsConfigGroup.getAverageLinkStatsOverIterations(), this.linkStatsConfigGroup.getWriteLinkStatsInterval());
        if (iterationMod == 0) {
            return this.linkStatsConfigGroup.getAverageLinkStatsOverIterations() <= 1 || effectiveIteration >= averaging;
        }
        return iterationMod > this.linkStatsConfigGroup.getWriteLinkStatsInterval() - this.linkStatsConfigGroup.getAverageLinkStatsOverIterations() && effectiveIteration + (this.linkStatsConfigGroup.getWriteLinkStatsInterval() - iterationMod) >= averaging;
    }

    boolean createLinkStatsInIteration(int iteration) {
        return iteration % this.linkStatsConfigGroup.getWriteLinkStatsInterval() == 0 && this.iterationsUsed >= this.linkStatsConfigGroup.getAverageLinkStatsOverIterations();
    }
}

