/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.ShutdownEvent;
import org.matsim.core.controler.events.StartupEvent;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.ShutdownListener;
import org.matsim.core.controler.listener.StartupListener;
import org.matsim.core.router.MainModeIdentifier;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.core.utils.charts.XYLineChart;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;

public class ModeStatsControlerListener
implements StartupListener,
IterationEndsListener,
ShutdownListener {
    public static final String FILENAME_MODESTATS = "modestats";
    private final Population population;
    private final BufferedWriter modeOut;
    private final String modeFileName;
    private final boolean createPNG;
    private final ControlerConfigGroup controlerConfigGroup;
    Map<String, Map<Integer, Double>> modeHistories = new HashMap<String, Map<Integer, Double>>();
    private int minIteration = 0;
    private final Provider<TripRouter> tripRouterFactory;
    private StageActivityTypes stageActivities;
    private MainModeIdentifier mainModeIdentifier;
    private Map<String, Double> modeCnt = new TreeMap<String, Double>();
    private final Set<String> modes;
    private static final Logger log = Logger.getLogger(ModeStatsControlerListener.class);

    @Inject
    ModeStatsControlerListener(ControlerConfigGroup controlerConfigGroup, Population population1, OutputDirectoryHierarchy controlerIO, PlanCalcScoreConfigGroup scoreConfig, Provider<TripRouter> tripRouterFactory) {
        this.controlerConfigGroup = controlerConfigGroup;
        this.population = population1;
        this.modeFileName = controlerIO.getOutputFilename(FILENAME_MODESTATS);
        this.createPNG = controlerConfigGroup.isCreateGraphs();
        this.modeOut = IOUtils.getBufferedWriter(this.modeFileName + ".txt");
        try {
            this.modeOut.write("Iteration");
            this.modes = new TreeSet<String>();
            this.modes.addAll(scoreConfig.getAllModes());
            for (String mode : this.modes) {
                this.modeOut.write("\t" + mode);
            }
            this.modeOut.write("\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.tripRouterFactory = tripRouterFactory;
    }

    @Override
    public void notifyStartup(StartupEvent event) {
        this.minIteration = this.controlerConfigGroup.getFirstIteration();
        TripRouter tripRouter = this.tripRouterFactory.get();
        this.stageActivities = tripRouter.getStageActivityTypes();
        this.mainModeIdentifier = tripRouter.getMainModeIdentifier();
    }

    @Override
    public void notifyIterationEnds(IterationEndsEvent event) {
        this.collectModeShareInfo(event);
    }

    private void collectModeShareInfo(IterationEndsEvent event) {
        for (Person person : this.population.getPersons().values()) {
            Iterator<String> plan = (Plan)person.getSelectedPlan();
            List<TripStructureUtils.Trip> trips = TripStructureUtils.getTrips((Plan)((Object)plan), this.stageActivities);
            for (TripStructureUtils.Trip trip : trips) {
                String mode = this.mainModeIdentifier.identifyMainMode(trip.getTripElements());
                Double cnt = this.modeCnt.get(mode);
                if (cnt == null) {
                    cnt = 0.0;
                }
                this.modeCnt.put(mode, cnt + 1.0);
            }
        }
        double sum = 0.0;
        for (Double val : this.modeCnt.values()) {
            sum += val.doubleValue();
        }
        try {
            this.modeOut.write(String.valueOf(event.getIteration()));
            for (String mode : this.modes) {
                Double cnt = this.modeCnt.get(mode);
                double share = 0.0;
                if (cnt != null) {
                    share = cnt / sum;
                }
                log.info("-- mode share of mode " + mode + " = " + share);
                this.modeOut.write("\t" + share);
                Map<Integer, Double> modeHistory = this.modeHistories.get(mode);
                if (modeHistory == null) {
                    modeHistory = new TreeMap<Integer, Double>();
                    this.modeHistories.put(mode, modeHistory);
                }
                modeHistory.put(event.getIteration(), share);
            }
            this.modeOut.write("\n");
            this.modeOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.createPNG && event.getIteration() > this.minIteration) {
            XYLineChart chart = new XYLineChart("Mode Statistics", "iteration", "mode");
            for (Map.Entry<String, Map<Integer, Double>> entry : this.modeHistories.entrySet()) {
                String mode = entry.getKey();
                Map<Integer, Double> history = entry.getValue();
                chart.addSeries(mode, history);
            }
            chart.addMatsimLogo();
            chart.saveAsPng(this.modeFileName + ".png", 800, 600);
        }
        this.modeCnt.clear();
    }

    @Override
    public void notifyShutdown(ShutdownEvent controlerShudownEvent) {
        try {
            this.modeOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

