/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.analysis.ScoreStats;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.ShutdownEvent;
import org.matsim.core.controler.events.StartupEvent;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.ShutdownListener;
import org.matsim.core.controler.listener.StartupListener;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.router.TripRouter;
import org.matsim.core.utils.charts.XYLineChart;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;

public class ScoreStatsControlerListener
implements StartupListener,
IterationEndsListener,
ShutdownListener,
ScoreStats {
    public static final String FILENAME_SCORESTATS = "scorestats";
    private final Population population;
    private final BufferedWriter out;
    private final String fileName;
    private final boolean createPNG;
    private final ControlerConfigGroup controlerConfigGroup;
    Map<ScoreItem, Map<Integer, Double>> scoreHistory = new HashMap<ScoreItem, Map<Integer, Double>>();
    private int minIteration = 0;
    private static final Logger log = Logger.getLogger(ScoreStatsControlerListener.class);

    @Inject
    ScoreStatsControlerListener(ControlerConfigGroup controlerConfigGroup, Population population1, OutputDirectoryHierarchy controlerIO, PlanCalcScoreConfigGroup scoreConfig, Provider<TripRouter> tripRouterFactory) {
        this.controlerConfigGroup = controlerConfigGroup;
        this.population = population1;
        this.fileName = controlerIO.getOutputFilename(FILENAME_SCORESTATS);
        this.createPNG = controlerConfigGroup.isCreateGraphs();
        this.out = IOUtils.getBufferedWriter(this.fileName + ".txt");
        try {
            this.out.write("ITERATION\tavg. EXECUTED\tavg. WORST\tavg. AVG\tavg. BEST\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void notifyStartup(StartupEvent event) {
        this.minIteration = this.controlerConfigGroup.getFirstIteration();
        for (ScoreItem item : ScoreItem.values()) {
            this.scoreHistory.put(item, new TreeMap());
        }
    }

    @Override
    public void notifyIterationEnds(IterationEndsEvent event) {
        this.collectScoreInfo(event);
    }

    private void collectScoreInfo(IterationEndsEvent event) {
        double sumScoreWorst = 0.0;
        double sumScoreBest = 0.0;
        double sumAvgScores = 0.0;
        double sumExecutedScores = 0.0;
        int nofScoreWorst = 0;
        int nofScoreBest = 0;
        int nofAvgScores = 0;
        int nofExecutedScores = 0;
        for (Person person : this.population.getPersons().values()) {
            Plan worstPlan = null;
            Plan bestPlan = null;
            double worstScore = Double.POSITIVE_INFINITY;
            double bestScore = Double.NEGATIVE_INFINITY;
            double sumScores = 0.0;
            double cntScores = 0.0;
            for (Plan plan : person.getPlans()) {
                if (plan.getScore() == null) continue;
                double score = plan.getScore();
                if (worstPlan == null) {
                    worstPlan = plan;
                    worstScore = score;
                } else if (score < worstScore) {
                    worstPlan = plan;
                    worstScore = score;
                }
                if (bestPlan == null) {
                    bestPlan = plan;
                    bestScore = score;
                } else if (score > bestScore) {
                    bestPlan = plan;
                    bestScore = score;
                }
                sumScores += score;
                cntScores += 1.0;
                if (!PersonUtils.isSelected(plan)) continue;
                sumExecutedScores += score;
                ++nofExecutedScores;
            }
            if (worstPlan != null) {
                ++nofScoreWorst;
                sumScoreWorst += worstScore;
            }
            if (bestPlan != null) {
                ++nofScoreBest;
                sumScoreBest += bestScore;
            }
            if (!(cntScores > 0.0)) continue;
            sumAvgScores += sumScores / cntScores;
            ++nofAvgScores;
        }
        log.info("-- avg. score of the executed plan of each agent: " + sumExecutedScores / (double)nofExecutedScores);
        log.info("-- avg. score of the worst plan of each agent: " + sumScoreWorst / (double)nofScoreWorst);
        log.info("-- avg. of the avg. plan score per agent: " + sumAvgScores / (double)nofAvgScores);
        log.info("-- avg. score of the best plan of each agent: " + sumScoreBest / (double)nofScoreBest);
        try {
            this.out.write(event.getIteration() + "\t" + sumExecutedScores / (double)nofExecutedScores + "\t" + sumScoreWorst / (double)nofScoreWorst + "\t" + sumAvgScores / (double)nofAvgScores + "\t" + sumScoreBest / (double)nofScoreBest + "\n");
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.scoreHistory.get((Object)ScoreItem.worst).put(event.getIteration(), sumScoreWorst / (double)nofScoreWorst);
        this.scoreHistory.get((Object)ScoreItem.best).put(event.getIteration(), sumScoreBest / (double)nofScoreBest);
        this.scoreHistory.get((Object)ScoreItem.average).put(event.getIteration(), sumAvgScores / (double)nofAvgScores);
        this.scoreHistory.get((Object)ScoreItem.executed).put(event.getIteration(), sumExecutedScores / (double)nofExecutedScores);
        if (this.createPNG && event.getIteration() > this.minIteration) {
            XYLineChart chart = new XYLineChart("Score Statistics", "iteration", "score");
            chart.addSeries("avg. worst score", this.scoreHistory.get((Object)ScoreItem.worst));
            chart.addSeries("avg. best score", this.scoreHistory.get((Object)ScoreItem.best));
            chart.addSeries("avg. of plans' average score", this.scoreHistory.get((Object)ScoreItem.average));
            chart.addSeries("avg. executed score", this.scoreHistory.get((Object)ScoreItem.executed));
            chart.addMatsimLogo();
            chart.saveAsPng(this.fileName + ".png", 800, 600);
        }
    }

    @Override
    public void notifyShutdown(ShutdownEvent controlerShudownEvent) {
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<ScoreItem, Map<Integer, Double>> getScoreHistory() {
        return Collections.unmodifiableMap(this.scoreHistory);
    }

    public static enum ScoreItem {
        worst,
        best,
        average,
        executed;

    }
}

